/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.RoleManagerUpdatable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;

public class RoleManager {
    protected final RoleManagerUpdatable updatable;

    public RoleManager(Role role) {
        this.updatable = new RoleManagerUpdatable(role);
    }

    public JDA getJDA() {
        return this.updatable.getJDA();
    }

    public Guild getGuild() {
        return this.updatable.getGuild();
    }

    public Role getRole() {
        return this.updatable.getRole();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setName(String name) {
        return ((RoleManagerUpdatable)this.updatable.getNameField().setValue(name)).update();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setPermissions(long perms) {
        return this.updatable.getPermissionField().setValue(perms).update();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setPermissions(Permission ... permissions) {
        return this.setPermissions(Arrays.asList(permissions));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setPermissions(Collection<Permission> permissions) {
        return this.updatable.getPermissionField().setPermissions(permissions).update();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setColor(Color color) {
        return ((RoleManagerUpdatable)this.updatable.getColorField().setValue(color)).update();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setHoisted(boolean hoisted) {
        return ((RoleManagerUpdatable)this.updatable.getHoistedField().setValue(hoisted)).update();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setMentionable(boolean mentionable) {
        return ((RoleManagerUpdatable)this.updatable.getMentionableField().setValue(mentionable)).update();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> givePermissions(Permission ... perms) {
        return this.givePermissions(Arrays.asList(perms));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> givePermissions(Collection<Permission> perms) {
        return this.updatable.getPermissionField().givePermissions(perms).update();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> revokePermissions(Permission ... perms) {
        return this.revokePermissions(Arrays.asList(perms));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> revokePermissions(Collection<Permission> perms) {
        return this.updatable.getPermissionField().revokePermissions(perms).update();
    }
}

