/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.shadowfacts.discordchat.gnu.trove.map.TLongObjectMap;
import net.shadowfacts.discordchat.gnu.trove.map.hash.TLongObjectHashMap;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.SimpleLog;

public class EventCache {
    public static final SimpleLog LOG = SimpleLog.getLog("EventCache");
    private final Map<Type, TLongObjectMap<List<Runnable>>> eventCache = new HashMap<Type, TLongObjectMap<List<Runnable>>>();

    public void cache(Type type, long triggerId, Runnable handler) {
        TLongObjectMap triggerCache = this.eventCache.computeIfAbsent(type, k -> new TLongObjectHashMap());
        LinkedList<Runnable> items = (LinkedList<Runnable>)triggerCache.get(triggerId);
        if (items == null) {
            items = new LinkedList<Runnable>();
            triggerCache.put(triggerId, items);
        }
        items.add(handler);
    }

    public void playbackCache(Type type, long triggerId) {
        List<Runnable> items;
        try {
            items = this.eventCache.get((Object)type).get(triggerId);
        }
        catch (NullPointerException e) {
            return;
        }
        if (items != null && !items.isEmpty()) {
            LOG.debug("Replaying " + items.size() + " events from the EventCache for a " + (Object)((Object)type) + " with id: " + triggerId);
            LinkedList<Runnable> itemsCopy = new LinkedList<Runnable>(items);
            items.clear();
            for (Runnable item : itemsCopy) {
                item.run();
            }
        }
    }

    public int size() {
        return (int)this.eventCache.values().stream().mapToLong(typeMap -> typeMap.valueCollection().stream().mapToLong(List::size).sum()).sum();
    }

    public void clear() {
        this.eventCache.clear();
    }

    public static enum Type {
        USER,
        GUILD,
        CHANNEL,
        ROLE,
        RELATIONSHIP,
        CALL;

    }
}

