/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.MessageBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.IFakeable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Message;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageEmbed;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageReaction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.MessageEmbedImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Helpers;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class MessageImpl
implements Message {
    private static final Pattern EMOTE_PATTERN = Pattern.compile("<:([^:]+):([0-9]+)>");
    private final JDAImpl api;
    private final long id;
    private final MessageType type;
    private final MessageChannel channel;
    private final boolean fromWebhook;
    private boolean mentionsEveryone = false;
    private boolean isTTS = false;
    private boolean pinned;
    private String content;
    private String subContent = null;
    private String strippedContent = null;
    private User author;
    private OffsetDateTime time;
    private OffsetDateTime editedTime = null;
    private List<User> mentionedUsers = new LinkedList<User>();
    private List<TextChannel> mentionedChannels = new LinkedList<TextChannel>();
    private List<Role> mentionedRoles = new LinkedList<Role>();
    private List<Message.Attachment> attachments = new LinkedList<Message.Attachment>();
    private List<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
    private List<Emote> emotes = null;
    private List<MessageReaction> reactions = new LinkedList<MessageReaction>();

    public MessageImpl(long id, MessageChannel channel, boolean fromWebhook) {
        this(id, channel, fromWebhook, MessageType.DEFAULT);
    }

    public MessageImpl(long id, MessageChannel channel, boolean fromWebhook, MessageType type) {
        this.id = id;
        this.channel = channel;
        this.api = channel != null ? (JDAImpl)channel.getJDA() : null;
        this.fromWebhook = fromWebhook;
        this.type = type;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public RestAction<Void> pin() {
        return this.channel.pinMessageById(this.getIdLong());
    }

    @Override
    public RestAction<Void> unpin() {
        return this.channel.unpinMessageById(this.getIdLong());
    }

    @Override
    public RestAction<Void> addReaction(Emote emote) {
        Checks.notNull(emote, "Emote");
        MessageReaction reaction = this.reactions.parallelStream().filter(r -> Objects.equals(r.getEmote().getId(), emote.getId())).findFirst().orElse(null);
        if (reaction == null) {
            this.checkFake(emote, "Emote");
            if (!emote.canInteract(this.api.getSelfUser(), this.channel)) {
                throw new IllegalArgumentException("Cannot react with the provided emote because it is not available in the current channel.");
            }
        } else if (reaction.isSelf()) {
            return new RestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        return this.channel.addReactionById(this.getIdLong(), emote);
    }

    @Override
    public RestAction<Void> addReaction(String unicode) {
        Checks.notEmpty(unicode, "Provided Unicode");
        MessageReaction reaction = this.reactions.parallelStream().filter(r -> Objects.equals(r.getEmote().getName(), unicode)).findFirst().orElse(null);
        if (reaction != null && reaction.isSelf()) {
            return new RestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        return this.channel.addReactionById(this.getIdLong(), unicode);
    }

    @Override
    public RestAction<Void> clearReactions() {
        if (!this.isFromType(ChannelType.TEXT)) {
            throw new IllegalStateException("Cannot clear reactions from a message in a Group or PrivateChannel.");
        }
        return this.getTextChannel().clearReactionsById(this.getId());
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public List<User> getMentionedUsers() {
        return Collections.unmodifiableList(this.mentionedUsers);
    }

    @Override
    public boolean isMentioned(User user) {
        return this.mentionsEveryone() || this.mentionedUsers.contains(user);
    }

    @Override
    public List<TextChannel> getMentionedChannels() {
        return Collections.unmodifiableList(this.mentionedChannels);
    }

    @Override
    public List<Role> getMentionedRoles() {
        return Collections.unmodifiableList(this.mentionedRoles);
    }

    @Override
    public boolean mentionsEveryone() {
        return this.mentionsEveryone;
    }

    @Override
    public boolean isEdited() {
        return this.editedTime != null;
    }

    @Override
    public OffsetDateTime getEditedTime() {
        return this.editedTime;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public Member getMember() {
        return this.isFromType(ChannelType.TEXT) ? this.getGuild().getMember(this.getAuthor()) : null;
    }

    @Override
    public synchronized String getStrippedContent() {
        if (this.strippedContent == null) {
            String tmp = this.getContent();
            String[] keys = new String[]{"*", "_", "`", "~~"};
            TreeSet<FormatToken> tokens = new TreeSet<FormatToken>((t1, t2) -> Integer.compare(t1.start, t2.start));
            for (String key : keys) {
                Matcher matcher = Pattern.compile(Pattern.quote(key)).matcher(tmp);
                while (matcher.find()) {
                    tokens.add(new FormatToken(key, matcher.start()));
                }
            }
            Stack<FormatToken> stack = new Stack<FormatToken>();
            ArrayList toRemove = new ArrayList();
            boolean inBlock = false;
            for (FormatToken token : tokens) {
                if (stack.empty() || !((FormatToken)stack.peek()).format.equals(token.format) || ((FormatToken)stack.peek()).start + token.format.length() == token.start) {
                    if (!inBlock) {
                        if (token.format.equals("`")) {
                            stack.clear();
                            inBlock = true;
                        }
                        stack.push(token);
                        continue;
                    }
                    if (!token.format.equals("`")) continue;
                    stack.push(token);
                    continue;
                }
                if (stack.empty()) continue;
                toRemove.add(stack.pop());
                toRemove.add(token);
                if (!token.format.equals("`") || !stack.empty()) continue;
                inBlock = false;
            }
            Collections.sort(toRemove, (t1, t2) -> Integer.compare(t1.start, t2.start));
            StringBuilder out = new StringBuilder();
            int currIndex = 0;
            for (FormatToken formatToken : toRemove) {
                if (currIndex < formatToken.start) {
                    out.append(tmp.substring(currIndex, formatToken.start));
                }
                currIndex = formatToken.start + formatToken.format.length();
            }
            if (currIndex < tmp.length()) {
                out.append(tmp.substring(currIndex));
            }
            this.strippedContent = out.toString().replace("*", "\\*").replace("_", "\\_").replace("~", "\\~");
        }
        return this.strippedContent;
    }

    @Override
    public synchronized String getContent() {
        if (this.subContent == null) {
            String tmp = this.content;
            for (User user : this.mentionedUsers) {
                if (this.isFromType(ChannelType.PRIVATE) || this.isFromType(ChannelType.GROUP)) {
                    tmp = tmp.replace("<@" + user.getId() + '>', '@' + user.getName()).replace("<@!" + user.getId() + '>', '@' + user.getName());
                    continue;
                }
                String name = this.getGuild().isMember(user) ? this.getGuild().getMember(user).getEffectiveName() : user.getName();
                tmp = tmp.replace("<@" + user.getId() + '>', '@' + name).replace("<@!" + user.getId() + '>', '@' + name);
            }
            for (Emote emote : this.getEmotes()) {
                tmp = tmp.replace(emote.getAsMention(), ":" + emote.getName() + ":");
            }
            for (TextChannel mentionedChannel : this.mentionedChannels) {
                tmp = tmp.replace("<#" + mentionedChannel.getId() + '>', '#' + mentionedChannel.getName());
            }
            for (Role mentionedRole : this.mentionedRoles) {
                tmp = tmp.replace("<@&" + mentionedRole.getId() + '>', '@' + mentionedRole.getName());
            }
            this.subContent = tmp;
        }
        return this.subContent;
    }

    @Override
    public String getRawContent() {
        return this.content;
    }

    @Override
    public boolean isFromType(ChannelType type) {
        return this.getChannelType() == type;
    }

    @Override
    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    @Override
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        return this.isFromType(ChannelType.PRIVATE) ? (PrivateChannel)this.channel : null;
    }

    @Override
    public Group getGroup() {
        return this.isFromType(ChannelType.GROUP) ? (Group)this.channel : null;
    }

    @Override
    public TextChannel getTextChannel() {
        return this.isFromType(ChannelType.TEXT) ? (TextChannel)this.channel : null;
    }

    @Override
    public Guild getGuild() {
        return this.isFromType(ChannelType.TEXT) ? this.getTextChannel().getGuild() : null;
    }

    @Override
    public List<Message.Attachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    @Override
    public List<MessageEmbed> getEmbeds() {
        return Collections.unmodifiableList(this.embeds);
    }

    @Override
    public synchronized List<Emote> getEmotes() {
        if (this.emotes == null) {
            this.emotes = new LinkedList<Emote>();
            Matcher matcher = EMOTE_PATTERN.matcher(this.getRawContent());
            while (matcher.find()) {
                String emoteIdString = matcher.group(2);
                long emoteId = Long.parseLong(emoteIdString);
                String emoteName = matcher.group(1);
                Emote emote = this.api.getEmoteById(emoteIdString);
                if (emote == null) {
                    emote = new EmoteImpl(emoteId, this.api).setName(emoteName);
                }
                this.emotes.add(emote);
            }
            this.emotes = Collections.unmodifiableList(this.emotes);
        }
        return this.emotes;
    }

    @Override
    public List<MessageReaction> getReactions() {
        return Collections.unmodifiableList(new LinkedList<MessageReaction>(this.reactions));
    }

    @Override
    public boolean isWebhookMessage() {
        return this.fromWebhook;
    }

    @Override
    public boolean isTTS() {
        return this.isTTS;
    }

    @Override
    public RestAction<Message> editMessage(String newContent) {
        return this.editMessage(new MessageBuilder().append(newContent).build());
    }

    @Override
    public RestAction<Message> editMessage(MessageEmbed newContent) {
        return this.editMessage(new MessageBuilder().setEmbed(newContent).build());
    }

    @Override
    public RestAction<Message> editMessageFormat(String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessage(new MessageBuilder().appendFormat(format, args).build());
    }

    @Override
    public RestAction<Message> editMessage(Message newContent) {
        if (!this.api.getSelfUser().equals(this.getAuthor())) {
            throw new IllegalStateException("Attempted to update message that was not sent by this account. You cannot modify other User's messages!");
        }
        return this.getChannel().editMessageById(this.getIdLong(), newContent);
    }

    @Override
    public AuditableRestAction<Void> delete() {
        if (!this.getJDA().getSelfUser().equals(this.getAuthor())) {
            if (this.isFromType(ChannelType.PRIVATE) || this.isFromType(ChannelType.GROUP)) {
                throw new IllegalStateException("Cannot delete another User's messages in a Group or PrivateChannel.");
            }
            if (!this.getGuild().getSelfMember().hasPermission((Channel)((TextChannel)this.getChannel()), Permission.MESSAGE_MANAGE)) {
                throw new InsufficientPermissionException(Permission.MESSAGE_MANAGE);
            }
        }
        return this.channel.deleteMessageById(this.getIdLong());
    }

    public MessageImpl setPinned(boolean pinned) {
        this.pinned = pinned;
        return this;
    }

    public MessageImpl setMentionedUsers(List<User> mentionedUsers) {
        this.mentionedUsers = mentionedUsers;
        return this;
    }

    public MessageImpl setMentionedChannels(List<TextChannel> mentionedChannels) {
        this.mentionedChannels = mentionedChannels;
        return this;
    }

    public MessageImpl setMentionedRoles(List<Role> mentionedRoles) {
        this.mentionedRoles = mentionedRoles;
        return this;
    }

    public MessageImpl setMentionsEveryone(boolean mentionsEveryone) {
        this.mentionsEveryone = mentionsEveryone;
        return this;
    }

    public MessageImpl setTTS(boolean TTS) {
        this.isTTS = TTS;
        return this;
    }

    public MessageImpl setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public MessageImpl setEditedTime(OffsetDateTime editedTime) {
        this.editedTime = editedTime;
        return this;
    }

    public MessageImpl setAuthor(User author) {
        this.author = author;
        return this;
    }

    public MessageImpl setContent(String content) {
        this.content = content;
        return this;
    }

    public MessageImpl setAttachments(List<Message.Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public MessageImpl setEmbeds(List<MessageEmbed> embeds) {
        this.embeds = embeds;
        return this;
    }

    public MessageImpl setReactions(List<MessageReaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MessageImpl)) {
            return false;
        }
        MessageImpl oMsg = (MessageImpl)o;
        return this == oMsg || this.id == oMsg.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return this.author != null ? String.format("M:%#s:%.20s(%s)", this.author, this, this.getId()) : String.format("M:%.20s", this);
    }

    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        obj.put("content", this.content);
        obj.put("tts", this.isTTS);
        if (!this.embeds.isEmpty()) {
            obj.put("embed", ((MessageEmbedImpl)this.embeds.get(0)).toJSONObject());
        }
        return obj;
    }

    private void checkPermission(Permission permission) {
        if (this.channel.getType() == ChannelType.TEXT) {
            Channel location = (Channel)((Object)this.channel);
            if (!location.getGuild().getSelfMember().hasPermission(location, permission)) {
                throw new InsufficientPermissionException(permission);
            }
        }
    }

    private void checkFake(IFakeable o, String name) {
        if (o.isFake()) {
            throw new IllegalArgumentException("We are unable to use a fake " + name + " in this situation!");
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String out;
        boolean upper = (flags & 2) == 2;
        boolean leftJustified = (flags & 1) == 1;
        boolean alt = (flags & 4) == 4;
        String string = out = alt ? this.getRawContent() : this.getContent();
        if (upper) {
            out = out.toUpperCase(formatter.locale());
        }
        try {
            Appendable appendable = formatter.out();
            if (precision > -1 && out.length() > precision) {
                appendable.append(Helpers.truncate(out, precision - 3)).append("...");
                return;
            }
            if (leftJustified) {
                appendable.append(Helpers.rightPad(out, width));
            } else {
                appendable.append(Helpers.leftPad(out, width));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class FormatToken {
        public final String format;
        public final int start;

        public FormatToken(String format, int start) {
            this.format = format;
            this.start = start;
        }
    }
}

