/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities;

import java.util.Objects;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;

public class Game {
    protected final String name;
    protected final String url;
    protected final GameType type;

    protected Game(String name) {
        this(name, null, GameType.DEFAULT);
    }

    protected Game(String name, String url) {
        this(name, url, GameType.STREAMING);
    }

    protected Game(String name, String url, GameType type) {
        this.name = name;
        this.url = url;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public GameType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Game)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Game oGame = (Game)o;
        return oGame.getType() == this.type && Objects.equals(this.name, oGame.getName()) && Objects.equals(this.url, oGame.getUrl());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.url});
    }

    public String toString() {
        if (this.url != null) {
            return String.format("Game(%s | %s)", this.name, this.url);
        }
        return String.format("Game(%s)", this.name);
    }

    public static Game of(String name) {
        return Game.of(name, null);
    }

    public static Game of(String name, String url) {
        Checks.notEmpty(name, "Provided game name");
        GameType type = Game.isValidStreamingUrl(url) ? GameType.STREAMING : GameType.DEFAULT;
        return new Game(name, url, type);
    }

    public static boolean isValidStreamingUrl(String url) {
        return url != null && url.matches("https?://(www\\.)?twitch\\.tv/.+");
    }

    public static enum GameType {
        DEFAULT(0),
        STREAMING(1),
        TWITCH(1);

        private final int key;

        private GameType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static GameType fromKey(int key) {
            for (GameType level : GameType.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return DEFAULT;
        }
    }
}

