/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.shadowlib.util.IOUtils;

public class Config
implements IConfig {
    private File file;
    private com.typesafe.config.Config config;

    public Config(File file) throws IOException {
        this.file = file;
        this.load();
    }

    @Override
    public void load() throws IOException {
        this.config = ConfigFactory.load().withFallback((ConfigMergeable)ConfigFactory.parseFile((File)this.file)).withFallback((ConfigMergeable)ConfigFactory.load((String)"assets/discordchat/default.conf"));
        if (this.config.hasPath("discordchat.discord.channel")) {
            String channel = this.config.getString("discordchat.discord.channel");
            this.config = this.config.withoutPath("discordchat.discord.channel");
            this.config = this.config.withValue("discordchat.discord.channels", ConfigValueFactory.fromAnyRef(Collections.singletonList(channel)));
        }
        this.save();
    }

    @Override
    public void save() throws IOException {
        if (!this.file.exists()) {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
        }
        ConfigObject toRender = this.config.root().withOnlyKey("discordchat");
        String s = toRender.render(ConfigRenderOptions.defaults().setOriginComments(false).setJson(false));
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8")));
        FileOutputStream out = new FileOutputStream(this.file);
        IOUtils.copy(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    @Override
    public String getToken() {
        return this.config.getString("discordchat.discord.token");
    }

    @Override
    public Long getServerID() {
        return this.config.getLong("discordchat.discord.server");
    }

    @Override
    public List<Long> getChannelIDs() {
        try {
            return this.config.getLongList("discordchat.discord.channels");
        }
        catch (ConfigException.WrongType e) {
            throw new RuntimeException("Unable to get channel IDs, update the config to use numeric channel IDs.", e);
        }
    }

    @Override
    public String getCommandPrefix() {
        return this.config.getString("discordchat.commands.prefix");
    }

    @Override
    public Permission getMinimumPermission(String command) {
        return Permission.valueOf(this.config.getString("discordchat.commands.permission." + command).toUpperCase());
    }

    @Override
    public IConfig.FilterMode getMCMessageFilterMode() {
        return IConfig.FilterMode.valueOf(this.config.getString("discordchat.filter.mode").toUpperCase());
    }

    @Override
    public String getMCMessageFilter() {
        return this.config.getString("discordchat.filter.filter");
    }

    @Override
    public boolean stripFilterPart() {
        return this.config.getBoolean("discordchat.filter.stripFilter");
    }

    @Override
    public boolean sendDeathMessages() {
        return this.config.getBoolean("discordchat.relay.deaths");
    }

    @Override
    public boolean sendAchievementMessages() {
        return this.config.getBoolean("discordchat.relay.achievements");
    }

    @Override
    public boolean sendJoinLeaveMessages() {
        return this.config.getBoolean("discordchat.relay.joinleave");
    }

    @Override
    public boolean sendServerOnlineOfflineMessages() {
        return this.config.getBoolean("discordchat.relay.onlineoffline");
    }

    @Override
    public String getDefaultColor() {
        return this.config.getString("discordchat.format.defaultColor");
    }

    @Override
    public String getFromMCFormat() {
        return this.config.getString("discordchat.format.fromMC");
    }

    @Override
    public String getFromDiscordFormat() {
        return this.config.getString("discordchat.format.fromDiscord");
    }

    @Override
    public String getFromMCPrivateFormat() {
        return this.config.getString("discordchat.format.fromMCPrivate");
    }

    @Override
    public String getFromDiscordPrivateFormat() {
        return this.config.getString("discordchat.format.fromDiscordPrivate");
    }

    @Override
    public String getDeathFormat() {
        return this.config.getString("discordchat.format.death");
    }

    @Override
    public String getAchievementFormat() {
        return this.config.getString("discordchat.format.achievement");
    }

    @Override
    public String getJoinFormat() {
        return this.config.getString("discordchat.format.join");
    }

    @Override
    public String getLeaveFormat() {
        return this.config.getString("discordchat.format.leave");
    }

    @Override
    public String getCommandFormat() {
        return this.config.getString("discordchat.format.command");
    }
}

