/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.api;

import java.util.Collections;
import java.util.List;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.ILogger;
import net.shadowfacts.discordchat.api.IMessageFormatter;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommandManager;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;

public interface IDiscordChat {
    public ILogger getLogger();

    public IConfig getConfig();

    public ICommandManager getCommandManager();

    public IPermissionManager getPermissionManager();

    public IMessageFormatter getFormatter();

    public JDA getJDA();

    public IMinecraftAdapter getMinecraftAdapter();

    public void connect();

    public void start();

    public void stop();

    default public boolean sendPrivateMessage(String sender, String message, String user) {
        List<Member> members = this.getJDA().getGuildById(this.getConfig().getServerID()).getMembersByEffectiveName(user, true);
        if (!members.isEmpty()) {
            members.get(0).getUser().openPrivateChannel().queue(channel -> this.sendMessage(this.getFormatter().fromMCPrivate(sender, message), (MessageChannel)channel));
            return true;
        }
        return false;
    }

    default public void sendMessage(String message, MessageChannel channel) {
        this.sendMessage(message, Collections.singletonList(channel));
    }

    public void sendMessage(String var1, List<? extends MessageChannel> var2);

    public void sendMessage(String var1);

    public String filterMCMessage(String var1);
}

