/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowlib.util;

import java.util.function.ToIntFunction;

public class NearestColor {
    public static <T> T find(int needle, T[] haystack, ToIntFunction<T> toInt) {
        int needleR = needle >> 16 & 0xFF;
        int needleG = needle >> 8 & 0xFF;
        int needleB = needle & 0xFF;
        double minDist = 2.147483647E9;
        T min = null;
        for (T t : haystack) {
            int color = toInt.applyAsInt(t);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            double dist = Math.sqrt(Math.pow(needleR - r, 2.0) + Math.pow(needleG - g, 2.0) + Math.pow(needleB - b, 2.0));
            if (!(dist < minDist)) continue;
            minDist = dist;
            min = t;
        }
        return min;
    }

    private static double distance(int r1, int g1, int b1, int r2, int g2, int b2) {
        int deltaR = r1 - r2;
        int deltaG = g1 - g2;
        int deltaB = b1 - b2;
        return Math.sqrt(2 * deltaR * deltaR + 4 * deltaG * deltaG + 2 * deltaB * deltaB);
    }
}

