/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.pagination;

import java.util.LinkedList;
import java.util.List;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageReaction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.MiscUtil;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;

public class ReactionPaginationAction
extends PaginationAction<User, ReactionPaginationAction> {
    protected final MessageReaction reaction;

    public ReactionPaginationAction(MessageReaction reaction) {
        super(reaction.getJDA(), Route.Messages.GET_REACTION_USERS.compile(reaction.getChannel().getId(), reaction.getMessageId(), ReactionPaginationAction.getCode(reaction)), 1, 100, 100);
        this.reaction = reaction;
    }

    protected static String getCode(MessageReaction reaction) {
        MessageReaction.ReactionEmote emote = reaction.getEmote();
        return emote.isEmote() ? emote.getName() + ":" + emote.getId() : MiscUtil.encodeUTF8(emote.getName());
    }

    public MessageReaction getReaction() {
        return this.reaction;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String after = null;
        String limit = String.valueOf(this.getLimit());
        User last = (User)this.last;
        if (last != null) {
            after = last.getId();
        }
        route = route.withQueryParams("limit", limit);
        if (after != null) {
            route = route.withQueryParams("after", after);
        }
        return route;
    }

    @Override
    protected void handleResponse(Response response, Request<List<User>> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = this.api.getEntityBuilder();
        JSONArray array = response.getArray();
        LinkedList<User> users = new LinkedList<User>();
        for (int i = 0; i < array.length(); ++i) {
            User user = builder.createFakeUser(array.getJSONObject(i), false);
            users.add(user);
            if (this.useCache) {
                this.cached.add(user);
            }
            this.last = user;
        }
        request.onSuccess(users);
    }
}

