/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests;

import java.util.LinkedList;
import java.util.List;
import net.shadowfacts.discordchat.repack.gnu.trove.map.TLongObjectMap;
import net.shadowfacts.discordchat.repack.gnu.trove.map.hash.TLongObjectHashMap;
import net.shadowfacts.discordchat.repack.gnu.trove.set.TLongSet;
import net.shadowfacts.discordchat.repack.gnu.trove.set.hash.TLongHashSet;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.SimpleLog;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GuildLock {
    public static final SimpleLog LOG = SimpleLog.getLog("JDAGuildLock");
    private final JDA api;
    private final TLongObjectMap<List<JSONObject>> cache = new TLongObjectHashMap<List<JSONObject>>();
    private final TLongSet cached = new TLongHashSet();

    public boolean isLocked(long guildId) {
        return this.cached.contains(guildId);
    }

    public void lock(long guildId) {
        if (!this.isLocked(guildId)) {
            this.cached.add(guildId);
            this.cache.put(guildId, new LinkedList());
        }
    }

    public void unlock(long guildId) {
        if (this.isLocked(guildId)) {
            this.cached.remove(guildId);
            List<JSONObject> events = this.cache.remove(guildId);
            if (events.size() > 0) {
                LOG.debug("Replaying " + events.size() + " events for unlocked guild with id " + guildId);
                ((JDAImpl)this.api).getClient().handle(events);
                LOG.debug("Finished replaying events for guild with id " + guildId);
            }
        }
    }

    public void queue(long guildId, JSONObject event) {
        if (this.isLocked(guildId)) {
            LOG.debug("Queueing up event for guild with id " + guildId + ": " + event.toString());
            this.cache.get(guildId).add(event);
        }
    }

    public void clear() {
        this.cache.clear();
        this.cached.clear();
    }

    public GuildLock(JDA api) {
        this.api = api;
    }
}

