/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.shadowfacts.discordchat.repack.gnu.trove.TDecorators;
import net.shadowfacts.discordchat.repack.gnu.trove.list.linked.TLongLinkedList;
import net.shadowfacts.discordchat.repack.gnu.trove.map.TLongObjectMap;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateIconEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateNameEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateOwnerEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.IPermissionHolder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PermissionOverride;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateNSFWEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateNameEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePermissionsEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePositionEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateTopicEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateBitrateEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateNameEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePermissionsEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePositionEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateUserLimitEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class ChannelUpdateHandler
extends SocketHandler {
    public ChannelUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if (type == ChannelType.GROUP) {
            this.handleGroup(content);
            return null;
        }
        ArrayList<IPermissionHolder> changed = new ArrayList<IPermissionHolder>();
        ArrayList<IPermissionHolder> contained = new ArrayList<IPermissionHolder>();
        long channelId = content.getLong("id");
        int position = content.getInt("position");
        String name = content.getString("name");
        boolean nsfw = !content.isNull("nsfw") && content.getBoolean("nsfw");
        JSONArray permOverwrites = content.getJSONArray("permission_overwrites");
        switch (type) {
            case TEXT: {
                String topic = content.isNull("topic") ? null : content.getString("topic");
                TextChannelImpl textChannel = (TextChannelImpl)this.api.getTextChannelMap().get(channelId);
                if (textChannel == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a TextChannel that does not exist. JSON: " + content);
                    return null;
                }
                String oldName = textChannel.getName();
                String oldTopic = textChannel.getTopic();
                int oldPosition = textChannel.getPositionRaw();
                boolean oldNsfw = textChannel.isNSFW();
                if (!Objects.equals(oldName, name)) {
                    textChannel.setName(name);
                    this.api.getEventManager().handle(new TextChannelUpdateNameEvent(this.api, this.responseNumber, textChannel, oldName));
                }
                if (!Objects.equals(oldTopic, topic)) {
                    textChannel.setTopic(topic);
                    this.api.getEventManager().handle(new TextChannelUpdateTopicEvent(this.api, this.responseNumber, textChannel, oldTopic));
                }
                if (oldPosition != position) {
                    textChannel.setRawPosition(position);
                    this.api.getEventManager().handle(new TextChannelUpdatePositionEvent(this.api, this.responseNumber, textChannel, oldPosition));
                }
                if (oldNsfw != nsfw) {
                    textChannel.setNSFW(nsfw);
                    this.api.getEventManager().handle(new TextChannelUpdateNSFWEvent(this.api, this.responseNumber, textChannel, nsfw));
                }
                this.applyPermissions(textChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.api.getEventManager().handle(new TextChannelUpdatePermissionsEvent(this.api, this.responseNumber, textChannel, changed));
                break;
            }
            case VOICE: {
                VoiceChannelImpl voiceChannel = (VoiceChannelImpl)this.api.getVoiceChannelMap().get(channelId);
                int userLimit = content.getInt("user_limit");
                int bitrate = content.getInt("bitrate");
                if (voiceChannel == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a VoiceChannel that does not exist. JSON: " + content);
                    return null;
                }
                String oldName = voiceChannel.getName();
                int oldPosition = voiceChannel.getPositionRaw();
                int oldLimit = voiceChannel.getUserLimit();
                int oldBitrate = voiceChannel.getBitrate();
                if (!Objects.equals(oldName, name)) {
                    voiceChannel.setName(name);
                    this.api.getEventManager().handle(new VoiceChannelUpdateNameEvent(this.api, this.responseNumber, voiceChannel, oldName));
                }
                if (oldPosition != position) {
                    voiceChannel.setRawPosition(position);
                    this.api.getEventManager().handle(new VoiceChannelUpdatePositionEvent(this.api, this.responseNumber, voiceChannel, oldPosition));
                }
                if (oldLimit != userLimit) {
                    voiceChannel.setUserLimit(userLimit);
                    this.api.getEventManager().handle(new VoiceChannelUpdateUserLimitEvent(this.api, this.responseNumber, voiceChannel, oldLimit));
                }
                if (oldBitrate != bitrate) {
                    voiceChannel.setBitrate(bitrate);
                    this.api.getEventManager().handle(new VoiceChannelUpdateBitrateEvent(this.api, this.responseNumber, voiceChannel, oldBitrate));
                }
                this.applyPermissions(voiceChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.api.getEventManager().handle(new VoiceChannelUpdatePermissionsEvent(this.api, this.responseNumber, voiceChannel, changed));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized channel type JSON: " + content);
            }
        }
        return null;
    }

    private long getIdLong(IPermissionHolder permHolder) {
        if (permHolder instanceof Member) {
            return ((Member)permHolder).getUser().getIdLong();
        }
        return ((Role)permHolder).getIdLong();
    }

    private void applyPermissions(AbstractChannelImpl<?> channel, JSONObject content, JSONArray permOverwrites, List<IPermissionHolder> contained, List<IPermissionHolder> changed) {
        for (int i = 0; i < permOverwrites.length(); ++i) {
            this.handlePermissionOverride(permOverwrites.getJSONObject(i), channel, content, changed, contained);
        }
        TLongLinkedList toRemove = new TLongLinkedList();
        TLongObjectMap<PermissionOverride> overridesMap = channel.getOverrideMap();
        TDecorators.wrap(overridesMap.keySet()).stream().map(id -> this.mapPermissionHolder((long)id, channel.getGuild())).filter(Objects::nonNull).filter(permHolder -> !contained.contains(permHolder)).forEach(permHolder -> {
            changed.add((IPermissionHolder)permHolder);
            toRemove.add(this.getIdLong((IPermissionHolder)permHolder));
        });
        toRemove.forEach(id -> {
            overridesMap.remove(id);
            return true;
        });
    }

    private IPermissionHolder mapPermissionHolder(long id, Guild guild) {
        Role holder = guild.getRoleById(id);
        return holder == null ? guild.getMemberById(id) : holder;
    }

    private void handlePermissionOverride(JSONObject override, AbstractChannelImpl<?> channel, JSONObject content, List<IPermissionHolder> changedPermHolders, List<IPermissionHolder> containedPermHolders) {
        PermissionOverrideImpl permOverride;
        IPermissionHolder permHolder;
        long id = override.getLong("id");
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        switch (override.getString("type")) {
            case "role": {
                permHolder = channel.getGuild().getRoleById(id);
                if (permHolder != null) break;
                this.api.getEventCache().cache(EventCache.Type.ROLE, id, () -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for a Role that doesn't exist! RoleId: " + id + " JSON: " + content);
                return;
            }
            case "member": {
                permHolder = channel.getGuild().getMemberById(id);
                if (permHolder != null) break;
                this.api.getEventCache().cache(EventCache.Type.USER, id, () -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for Member that doesn't exist in this Guild! MemberId: " + id + " JSON: " + content);
                return;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized PermissionOverride type. JSON: " + content);
            }
        }
        if ((permOverride = (PermissionOverrideImpl)channel.getOverrideMap().get(id)) == null) {
            this.api.getEntityBuilder().createPermissionOverride(override, channel);
            changedPermHolders.add(permHolder);
        } else if (permOverride.getAllowedRaw() != allow || permOverride.getDeniedRaw() != deny) {
            permOverride.setAllow(allow);
            permOverride.setDeny(deny);
            changedPermHolders.add(permHolder);
        }
        containedPermHolders.add(permHolder);
    }

    private void handleGroup(JSONObject content) {
        long groupId = content.getLong("id");
        long ownerId = content.getLong("owner_id");
        String name = content.isNull("name") ? null : content.getString("name");
        String iconId = content.isNull("icon") ? null : content.getString("icon");
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, groupId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received CHANNEL_UPDATE for a group that was not yet cached. JSON: " + content);
            return;
        }
        User owner = group.getUserMap().get(ownerId);
        User oldOwner = group.getOwner();
        String oldName = group.getName();
        String oldIconId = group.getIconId();
        if (owner == null) {
            EventCache.LOG.warn("Received CHANNEL_UPDATE for a group with an owner_id for a user that is not cached. owner_id: " + ownerId);
        } else if (!Objects.equals(owner, oldOwner)) {
            group.setOwner(owner);
            this.api.getEventManager().handle(new GroupUpdateOwnerEvent(this.api, this.responseNumber, group, oldOwner));
        }
        if (!Objects.equals(name, oldName)) {
            group.setName(name);
            this.api.getEventManager().handle(new GroupUpdateNameEvent(this.api, this.responseNumber, group, oldName));
        }
        if (!Objects.equals(iconId, oldIconId)) {
            group.setIconId(iconId);
            this.api.getEventManager().handle(new GroupUpdateIconEvent(this.api, this.responseNumber, group, oldIconId));
        }
    }
}

