/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.WebSocketFactory;
import net.shadowfacts.discordchat.repack.gnu.trove.map.TLongObjectMap;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.bot.JDABot;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.bot.entities.impl.JDABotImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.JDAClient;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio.AudioWebSocket;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio.factory.DefaultSendFactory;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.SelfUser;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.StatusChangeEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks.IEventManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks.InterfacedEventManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.AudioManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.Presence;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.GuildLock;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Requester;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.SessionReconnectQueue;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.MiscUtil;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.SimpleLog;
import net.shadowfacts.discordchat.repack.okhttp3.OkHttpClient;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class JDAImpl
implements JDA {
    public static final SimpleLog LOG = SimpleLog.getLog("JDA");
    public final ScheduledThreadPoolExecutor pool;
    protected final TLongObjectMap<User> users = MiscUtil.newLongMap();
    protected final TLongObjectMap<Guild> guilds = MiscUtil.newLongMap();
    protected final TLongObjectMap<TextChannel> textChannels = MiscUtil.newLongMap();
    protected final TLongObjectMap<VoiceChannel> voiceChannels = MiscUtil.newLongMap();
    protected final TLongObjectMap<PrivateChannel> privateChannels = MiscUtil.newLongMap();
    protected final TLongObjectMap<User> fakeUsers = MiscUtil.newLongMap();
    protected final TLongObjectMap<PrivateChannel> fakePrivateChannels = MiscUtil.newLongMap();
    protected final TLongObjectMap<AudioManagerImpl> audioManagers = MiscUtil.newLongMap();
    protected final OkHttpClient.Builder httpClientBuilder;
    protected final WebSocketFactory wsFactory;
    protected final AccountType accountType;
    protected final PresenceImpl presence;
    protected final JDAClient jdaClient;
    protected final JDABot jdaBot;
    protected final int maxReconnectDelay;
    protected final Thread shutdownHook;
    protected final EntityBuilder entityBuilder = new EntityBuilder(this);
    protected final EventCache eventCache = new EventCache();
    protected final GuildLock guildLock = new GuildLock(this);
    protected final Object akapLock = new Object();
    protected WebSocketClient client;
    protected Requester requester;
    protected IEventManager eventManager = new InterfacedEventManager();
    protected IAudioSendFactory audioSendFactory = new DefaultSendFactory();
    protected ScheduledThreadPoolExecutor audioKeepAlivePool;
    protected JDA.Status status = JDA.Status.INITIALIZING;
    protected SelfUser selfUser;
    protected JDA.ShardInfo shardInfo;
    protected String token = null;
    protected boolean audioEnabled;
    protected boolean bulkDeleteSplittingEnabled;
    protected boolean autoReconnect;
    protected long responseTotal;
    protected long ping = -1L;

    public JDAImpl(AccountType accountType, OkHttpClient.Builder httpClientBuilder, WebSocketFactory wsFactory, boolean autoReconnect, boolean audioEnabled, boolean useShutdownHook, boolean bulkDeleteSplittingEnabled, int corePoolSize, int maxReconnectDelay) {
        this.accountType = accountType;
        this.httpClientBuilder = httpClientBuilder;
        this.wsFactory = wsFactory;
        this.autoReconnect = autoReconnect;
        this.audioEnabled = audioEnabled;
        this.shutdownHook = useShutdownHook ? new Thread(this::shutdown, "JDA Shutdown Hook") : null;
        this.bulkDeleteSplittingEnabled = bulkDeleteSplittingEnabled;
        this.pool = new ScheduledThreadPoolExecutor(corePoolSize, new JDAThreadFactory());
        this.maxReconnectDelay = maxReconnectDelay;
        this.presence = new PresenceImpl(this);
        this.requester = new Requester(this);
        this.jdaClient = accountType == AccountType.CLIENT ? new JDAClientImpl(this) : null;
        this.jdaBot = accountType == AccountType.BOT ? new JDABotImpl(this) : null;
    }

    public void login(String token, JDA.ShardInfo shardInfo, SessionReconnectQueue reconnectQueue) throws LoginException, RateLimitedException {
        this.setStatus(JDA.Status.LOGGING_IN);
        if (token == null || token.isEmpty()) {
            throw new LoginException("Provided token was null or empty!");
        }
        this.setToken(token);
        this.verifyToken();
        this.shardInfo = shardInfo;
        LOG.info("Login Successful!");
        this.client = new WebSocketClient(this, reconnectQueue);
        if (this.shutdownHook != null) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(JDA.Status status) {
        JDA.Status status2 = this.status;
        synchronized (status2) {
            JDA.Status oldStatus = this.status;
            this.status = status;
            this.eventManager.handle(new StatusChangeEvent(this, status, oldStatus));
        }
    }

    public void setToken(String token) {
        this.token = this.getAccountType() == AccountType.BOT ? "Bot " + token : token;
    }

    public void verifyToken() throws LoginException, RateLimitedException {
        JSONObject userResponse;
        RestAction<JSONObject> login = new RestAction<JSONObject>((JDA)this, Route.Self.GET_SELF.compile(new String[0])){

            @Override
            protected void handleResponse(Response response, Request<JSONObject> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject());
                } else if (response.isRateLimit()) {
                    request.onFailure(new RateLimitedException(request.getRoute(), response.retryAfter));
                } else if (response.code == 401) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(new LoginException("When verifying the authenticity of the provided token, Discord returned an unknown response:\n" + response.toString()));
                }
            }
        };
        try {
            userResponse = (JSONObject)login.complete(false);
        }
        catch (RuntimeException e) {
            Throwable ex;
            Throwable throwable = ex = e.getCause() != null ? e.getCause().getCause() : null;
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw e;
        }
        if (userResponse != null) {
            this.verifyToken(userResponse);
        } else {
            if (this.getAccountType() == AccountType.BOT) {
                this.token = this.token.replace("Bot ", "");
                this.requester = new Requester(this, AccountType.CLIENT);
            } else {
                this.token = "Bot " + this.token;
                this.requester = new Requester(this, AccountType.BOT);
            }
            try {
                userResponse = (JSONObject)login.complete(false);
            }
            catch (RuntimeException e) {
                Throwable ex;
                Throwable throwable = ex = e.getCause() != null ? e.getCause().getCause() : null;
                if (ex instanceof LoginException) {
                    throw (LoginException)ex;
                }
                throw e;
            }
            if (userResponse != null) {
                this.verifyToken(userResponse);
            } else {
                throw new LoginException("The provided token is invalid!");
            }
        }
    }

    private void verifyToken(JSONObject userResponse) {
        if (this.getAccountType() == AccountType.BOT) {
            if (!userResponse.has("bot") || !userResponse.getBoolean("bot")) {
                throw new AccountTypeException(AccountType.BOT, "Attempted to login as a BOT with a CLIENT token!");
            }
        } else if (userResponse.has("bot") && userResponse.getBoolean("bot")) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to login as a CLIENT with a BOT token!");
        }
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    @Override
    public boolean isBulkDeleteSplittingEnabled() {
        return this.bulkDeleteSplittingEnabled;
    }

    @Override
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        if (this.client != null) {
            this.client.setAutoReconnect(autoReconnect);
        }
    }

    @Override
    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Override
    public JDA.Status getStatus() {
        return this.status;
    }

    @Override
    public long getPing() {
        return this.ping;
    }

    @Override
    public List<String> getCloudflareRays() {
        return Collections.unmodifiableList(new LinkedList<String>(this.client.getCfRays()));
    }

    @Override
    public List<String> getWebSocketTrace() {
        return Collections.unmodifiableList(new LinkedList<String>(this.client.getTraces()));
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.users.valueCollection()));
    }

    @Override
    public User getUserById(String id) {
        return this.users.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public User getUserById(long id) {
        return this.users.get(id);
    }

    @Override
    public List<Guild> getMutualGuilds(User ... users) {
        Checks.notNull(users, "users");
        return this.getMutualGuilds(Arrays.asList(users));
    }

    @Override
    public List<Guild> getMutualGuilds(Collection<User> users) {
        Checks.notNull(users, "users");
        for (User u : users) {
            Checks.notNull(u, "All users");
        }
        return Collections.unmodifiableList(this.getGuilds().stream().filter(guild -> users.stream().allMatch(guild::isMember)).collect(Collectors.toList()));
    }

    @Override
    public List<User> getUsersByName(String name, boolean ignoreCase) {
        return this.users.valueCollection().stream().filter(u -> ignoreCase ? name.equalsIgnoreCase(u.getName()) : name.equals(u.getName())).collect(Collectors.toList());
    }

    @Override
    public RestAction<User> retrieveUserById(String id) {
        return this.retrieveUserById(MiscUtil.parseSnowflake(id));
    }

    @Override
    public RestAction<User> retrieveUserById(long id) {
        if (this.accountType != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        User user = this.getUserById(id);
        if (user != null) {
            return new RestAction.EmptyRestAction<User>((JDA)this, user);
        }
        Route.CompiledRoute route = Route.Users.GET_USER.compile(Long.toUnsignedString(id));
        return new RestAction<User>((JDA)this, route){

            @Override
            protected void handleResponse(Response response, Request<User> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONObject user = response.getObject();
                request.onSuccess(JDAImpl.this.getEntityBuilder().createFakeUser(user, false));
            }
        };
    }

    @Override
    public List<Guild> getGuilds() {
        return Collections.unmodifiableList(new ArrayList<Guild>(this.guilds.valueCollection()));
    }

    @Override
    public Guild getGuildById(String id) {
        return this.guilds.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public Guild getGuildById(long id) {
        return this.guilds.get(id);
    }

    @Override
    public List<Guild> getGuildsByName(String name, boolean ignoreCase) {
        return this.guilds.valueCollection().stream().filter(g -> ignoreCase ? name.equalsIgnoreCase(g.getName()) : name.equals(g.getName())).collect(Collectors.toList());
    }

    @Override
    public List<Role> getRoles() {
        return this.guilds.valueCollection().stream().flatMap(guild -> guild.getRoles().stream()).collect(Collectors.toList());
    }

    @Override
    public Role getRoleById(String id) {
        return this.getRoleById(MiscUtil.parseSnowflake(id));
    }

    @Override
    public Role getRoleById(long id) {
        for (Guild guild : this.guilds.valueCollection()) {
            Role r = guild.getRoleById(id);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Override
    public List<Role> getRolesByName(String name, boolean ignoreCase) {
        return this.guilds.valueCollection().stream().flatMap(guild -> guild.getRolesByName(name, ignoreCase).stream()).collect(Collectors.toList());
    }

    @Override
    public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(new ArrayList<TextChannel>(this.textChannels.valueCollection()));
    }

    @Override
    public TextChannel getTextChannelById(String id) {
        return this.textChannels.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public TextChannel getTextChannelById(long id) {
        return this.textChannels.get(id);
    }

    @Override
    public List<TextChannel> getTextChannelsByName(String name, boolean ignoreCase) {
        return this.textChannels.valueCollection().stream().filter(tc -> ignoreCase ? name.equalsIgnoreCase(tc.getName()) : name.equals(tc.getName())).collect(Collectors.toList());
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(new ArrayList<VoiceChannel>(this.voiceChannels.valueCollection()));
    }

    @Override
    public VoiceChannel getVoiceChannelById(String id) {
        return this.voiceChannels.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public VoiceChannel getVoiceChannelById(long id) {
        return this.voiceChannels.get(id);
    }

    @Override
    public List<VoiceChannel> getVoiceChannelByName(String name, boolean ignoreCase) {
        return this.voiceChannels.valueCollection().stream().filter(vc -> ignoreCase ? name.equalsIgnoreCase(vc.getName()) : name.equals(vc.getName())).collect(Collectors.toList());
    }

    @Override
    public List<PrivateChannel> getPrivateChannels() {
        return Collections.unmodifiableList(new ArrayList<PrivateChannel>(this.privateChannels.valueCollection()));
    }

    @Override
    public PrivateChannel getPrivateChannelById(String id) {
        return this.privateChannels.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public PrivateChannel getPrivateChannelById(long id) {
        return this.privateChannels.get(id);
    }

    @Override
    public List<Emote> getEmotes() {
        return this.guilds.valueCollection().stream().flatMap(guild -> guild.getEmotes().stream()).collect(Collectors.toList());
    }

    @Override
    public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        return this.guilds.valueCollection().stream().flatMap(guild -> guild.getEmotesByName(name, ignoreCase).stream()).collect(Collectors.toList());
    }

    @Override
    public Emote getEmoteById(String id) {
        return this.getEmoteById(MiscUtil.parseSnowflake(id));
    }

    @Override
    public Emote getEmoteById(long id) {
        for (Guild guild : this.getGuilds()) {
            Emote emote = guild.getEmoteById(id);
            if (emote == null) continue;
            return emote;
        }
        return null;
    }

    @Override
    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
        this.pool.shutdownNow();
        this.getRequester().shutdownNow();
    }

    @Override
    public void shutdown() {
        if (this.status == JDA.Status.SHUTDOWN || this.status == JDA.Status.SHUTTING_DOWN) {
            return;
        }
        this.setStatus(JDA.Status.SHUTTING_DOWN);
        this.audioManagers.valueCollection().forEach(AudioManager::closeAudioConnection);
        if (this.audioKeepAlivePool != null) {
            this.audioKeepAlivePool.shutdownNow();
        }
        this.getClient().setAutoReconnect(false);
        this.getClient().close();
        long time = 5L;
        TimeUnit unit = TimeUnit.SECONDS;
        this.getRequester().shutdown(5L, unit);
        this.pool.setKeepAliveTime(5L, unit);
        this.pool.allowCoreThreadTimeOut(true);
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setStatus(JDA.Status.SHUTDOWN);
    }

    @Override
    public JDAClient asClient() {
        if (this.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        return this.jdaClient;
    }

    @Override
    public JDABot asBot() {
        if (this.getAccountType() != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        return this.jdaBot;
    }

    @Override
    public long getResponseTotal() {
        return this.responseTotal;
    }

    @Override
    public int getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    @Override
    public JDA.ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public AuditableRestAction<Void> installAuxiliaryCable(int port) throws UnsupportedOperationException {
        return new AuditableRestAction.FailedRestAction<Void>(new UnsupportedOperationException("nice try but next time think first :)"));
    }

    @Override
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Override
    public void setEventManager(IEventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public void addEventListener(Object ... listeners) {
        for (Object listener : listeners) {
            this.eventManager.register(listener);
        }
    }

    @Override
    public void removeEventListener(Object ... listeners) {
        for (Object listener : listeners) {
            this.eventManager.unregister(listener);
        }
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(this.eventManager.getRegisteredListeners());
    }

    public EntityBuilder getEntityBuilder() {
        return this.entityBuilder;
    }

    public GuildLock getGuildLock() {
        return this.guildLock;
    }

    public IAudioSendFactory getAudioSendFactory() {
        return this.audioSendFactory;
    }

    public void setAudioSendFactory(IAudioSendFactory factory) {
        Checks.notNull(factory, "Provided IAudioSendFactory");
        this.audioSendFactory = factory;
    }

    public void setPing(long ping) {
        this.ping = ping;
    }

    public Requester getRequester() {
        return this.requester;
    }

    public IEventManager getEventManager() {
        return this.eventManager;
    }

    public WebSocketFactory getWebSocketFactory() {
        return this.wsFactory;
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public TLongObjectMap<User> getUserMap() {
        return this.users;
    }

    public TLongObjectMap<Guild> getGuildMap() {
        return this.guilds;
    }

    public TLongObjectMap<TextChannel> getTextChannelMap() {
        return this.textChannels;
    }

    public TLongObjectMap<VoiceChannel> getVoiceChannelMap() {
        return this.voiceChannels;
    }

    public TLongObjectMap<PrivateChannel> getPrivateChannelMap() {
        return this.privateChannels;
    }

    public TLongObjectMap<User> getFakeUserMap() {
        return this.fakeUsers;
    }

    public TLongObjectMap<PrivateChannel> getFakePrivateChannelMap() {
        return this.fakePrivateChannels;
    }

    public TLongObjectMap<AudioManagerImpl> getAudioManagerMap() {
        return this.audioManagers;
    }

    public void setSelfUser(SelfUser selfUser) {
        this.selfUser = selfUser;
    }

    public void setResponseTotal(int responseTotal) {
        this.responseTotal = responseTotal;
    }

    public String getIdentifierString() {
        if (this.shardInfo != null) {
            return "JDA " + this.shardInfo.getShardString();
        }
        return "JDA";
    }

    public EventCache getEventCache() {
        return this.eventCache;
    }

    public OkHttpClient.Builder getHttpClientBuilder() {
        return this.httpClientBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledThreadPoolExecutor getAudioKeepAlivePool() {
        ScheduledThreadPoolExecutor akap = this.audioKeepAlivePool;
        if (akap == null) {
            Object object = this.akapLock;
            synchronized (object) {
                akap = this.audioKeepAlivePool;
                if (akap == null) {
                    akap = this.audioKeepAlivePool = new ScheduledThreadPoolExecutor(1, new AudioWebSocket.KeepAliveThreadFactory(this));
                }
            }
        }
        return akap;
    }

    private class JDAThreadFactory
    implements ThreadFactory {
        private JDAThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "JDA-Thread " + JDAImpl.this.getIdentifierString());
            thread.setDaemon(true);
            return thread;
        }
    }
}

