/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.AudioChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.GuildVoiceState;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;

public class GuildVoiceStateImpl
implements GuildVoiceState {
    private final GuildImpl guild;
    private final Member member;
    private VoiceChannel connectedChannel;
    private String sessionId;
    private boolean selfMuted = false;
    private boolean selfDeafened = false;
    private boolean guildMuted = false;
    private boolean guildDeafened = false;
    private boolean suppressed = false;

    public GuildVoiceStateImpl(GuildImpl guild, Member member) {
        this.guild = guild;
        this.member = member;
    }

    @Override
    public boolean isSelfMuted() {
        return this.selfMuted;
    }

    @Override
    public boolean isSelfDeafened() {
        return this.selfDeafened;
    }

    @Override
    public JDAImpl getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public AudioChannel getAudioChannel() {
        return this.connectedChannel;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isMuted() {
        return this.isSelfMuted() || this.isGuildMuted();
    }

    @Override
    public boolean isDeafened() {
        return this.isSelfDeafened() || this.isGuildDeafened();
    }

    @Override
    public boolean isGuildMuted() {
        return this.guildMuted;
    }

    @Override
    public boolean isGuildDeafened() {
        return this.guildDeafened;
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressed;
    }

    @Override
    public VoiceChannel getChannel() {
        return this.connectedChannel;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public boolean inVoiceChannel() {
        return this.getChannel() != null;
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuildVoiceState)) {
            return false;
        }
        GuildVoiceState oStatus = (GuildVoiceState)obj;
        return this == oStatus || this.member.equals(oStatus.getMember()) && this.guild.equals(oStatus.getGuild());
    }

    public String toString() {
        return "VS:" + this.guild.getName() + ':' + this.member.getEffectiveName();
    }

    public GuildVoiceStateImpl setConnectedChannel(VoiceChannel connectedChannel) {
        this.connectedChannel = connectedChannel;
        return this;
    }

    public GuildVoiceStateImpl setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public GuildVoiceStateImpl setSelfMuted(boolean selfMuted) {
        this.selfMuted = selfMuted;
        return this;
    }

    public GuildVoiceStateImpl setSelfDeafened(boolean selfDeafened) {
        this.selfDeafened = selfDeafened;
        return this;
    }

    public GuildVoiceStateImpl setGuildMuted(boolean guildMuted) {
        this.guildMuted = guildMuted;
        return this;
    }

    public GuildVoiceStateImpl setGuildDeafened(boolean guildDeafened) {
        this.guildDeafened = guildDeafened;
        return this;
    }

    public GuildVoiceStateImpl setSuppressed(boolean suppressed) {
        this.suppressed = suppressed;
        return this;
    }
}

