/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.shadowfacts.discordchat.repack.gnu.trove.map.TLongObjectMap;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Call;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Friend;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Relationship;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.MiscUtil;

public class GroupImpl
implements Group {
    private final long id;
    private final JDAImpl api;
    private final TLongObjectMap<User> userMap = MiscUtil.newLongMap();
    private Call currentCall;
    private User owner;
    private String name;
    private String iconId;
    private long lastMessageId;

    public GroupImpl(long id, JDAImpl api) {
        this.id = id;
        this.api = api;
    }

    @Override
    public long getLatestMessageIdLong() {
        long messageId = this.lastMessageId;
        if (messageId < 0L) {
            throw new IllegalStateException("No last message id found.");
        }
        return messageId;
    }

    @Override
    public boolean hasLatestMessage() {
        return this.lastMessageId > 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.GROUP;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/channel-icons/" + this.id + "/" + this.iconId + ".jpg";
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.userMap.valueCollection()));
    }

    @Override
    public List<User> getNonFriendUsers() {
        ArrayList nonFriends = new ArrayList();
        TLongObjectMap<Relationship> map = ((JDAClientImpl)this.api.asClient()).getRelationshipMap();
        this.userMap.forEachEntry((userId, user) -> {
            Friend friend;
            Relationship relationship = (Relationship)map.get(userId);
            Friend friend2 = friend = relationship instanceof Friend ? (Friend)relationship : null;
            if (friend == null) {
                nonFriends.add(user);
            }
            return true;
        });
        return Collections.unmodifiableList(nonFriends);
    }

    @Override
    public List<Friend> getFriends() {
        ArrayList friends = new ArrayList();
        TLongObjectMap<Relationship> map = ((JDAClientImpl)this.api.asClient()).getRelationshipMap();
        this.userMap.forEachKey(userId -> {
            Friend friend;
            Relationship relationship = (Relationship)map.get(userId);
            Friend friend2 = friend = relationship instanceof Friend ? (Friend)relationship : null;
            if (friend != null) {
                friends.add(friend);
            }
            return true;
        });
        return Collections.unmodifiableList(friends);
    }

    @Override
    public RestAction<Call> startCall() {
        return null;
    }

    @Override
    public Call getCurrentCall() {
        return this.currentCall;
    }

    @Override
    public RestAction leaveGroup() {
        return null;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    public String toString() {
        return String.format("G:%s(%d)", this.getName(), this.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupImpl)) {
            return false;
        }
        GroupImpl oGroup = (GroupImpl)o;
        return this.id == oGroup.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public TLongObjectMap<User> getUserMap() {
        return this.userMap;
    }

    public GroupImpl setCurrentCall(Call call) {
        this.currentCall = call;
        return this;
    }

    public GroupImpl setOwner(User owner) {
        this.owner = owner;
        return this;
    }

    public GroupImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GroupImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GroupImpl setLastMessageId(long lastMessageId) {
        this.lastMessageId = lastMessageId;
        return this;
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }

    @Override
    public long getIdLong() {
        return this.id;
    }
}

