/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.one_seven_ten;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import java.io.File;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.core.DiscordChat;
import net.shadowfacts.discordchat.one_seven_ten.CommandDC;
import net.shadowfacts.discordchat.one_seven_ten.FMLEventHandler;
import net.shadowfacts.discordchat.one_seven_ten.ForgeEventHandler;
import net.shadowfacts.discordchat.one_seven_ten.OneSevenTenAdapter;

@Mod(modid="discordchat", name="Discord Chat", version="2.3.0", acceptableRemoteVersions="*")
public class OneSevenTenMod {
    public static final String MOD_ID = "discordchat";
    public static final String NAME = "Discord Chat";
    public static final String VERSION = "2.3.0";
    public static IMinecraftAdapter minecraftAdapter = new OneSevenTenAdapter();
    public static IConfig config;
    public static IDiscordChat discordChat;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        discordChat = new DiscordChat(new File(event.getModConfigurationDirectory(), "shadowfacts/DiscordChat/"), minecraftAdapter);
        config = discordChat.getConfig();
        discordChat.connect();
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDC(discordChat));
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        discordChat.start();
        if (config.sendServerOnlineOfflineMessages()) {
            discordChat.sendMessage("Server is online");
        }
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        if (config.sendServerOnlineOfflineMessages()) {
            discordChat.sendMessage("Server is offline");
        }
        discordChat.stop();
    }
}

