/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.permission;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.ILogger;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.shadowlib.util.IOUtils;

public class PermissionManager
implements IPermissionManager {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)PermissionStore.class), new Deserializer()).setPrettyPrinting().create();
    private static ILogger logger;
    private File file;
    private PermissionStore permissions;

    public PermissionManager(IDiscordChat discordChat, File file) throws IOException {
        logger = discordChat.getLogger();
        this.file = file;
        this.load();
    }

    @Override
    public Permission get(Role role) {
        return this.permissions.containsKey(role.getId()) ? (Permission)((Object)this.permissions.get(role.getId())) : Permission.GLOBAL;
    }

    @Override
    public void set(Role role, Permission permission) {
        this.permissions.put(role.getId(), permission);
    }

    @Override
    public void load() throws IOException {
        if (this.file.exists()) {
            this.permissions = GSON.fromJson((Reader)new FileReader(this.file), PermissionStore.class);
        } else {
            this.permissions = new PermissionStore();
            this.save();
        }
    }

    @Override
    public void save() throws IOException {
        String s = new Gson().toJson(this.permissions);
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        FileOutputStream out = new FileOutputStream(this.file);
        IOUtils.copy(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static class Deserializer
    implements JsonDeserializer<PermissionStore> {
        private Deserializer() {
        }

        @Override
        public PermissionStore deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            PermissionStore store = new PermissionStore();
            JsonObject obj = json.getAsJsonObject();
            obj.entrySet().forEach(e -> {
                try {
                    store.put(e.getKey(), Permission.valueOf(((JsonElement)e.getValue()).getAsString().toUpperCase()));
                }
                catch (IllegalArgumentException ex) {
                    logger.warn(ex, "Invalid permission '" + ((JsonElement)e.getValue()).getAsString() + "' for user '" + (String)e.getKey() + "'", new Object[0]);
                }
            });
            return store;
        }
    }

    private static class PermissionStore
    extends HashMap<String, Permission> {
        private PermissionStore() {
        }
    }
}

