/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.meta;

import java.util.List;
import java.util.stream.Collectors;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.ICommandManager;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandCommands
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private ICommandManager commandManager;
    private IPermissionManager permissionManager;

    public CommandCommands(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.commandManager = discordChat.getCommandManager();
        this.permissionManager = discordChat.getPermissionManager();
    }

    @Override
    public String getName() {
        return "commands";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User author, MessageChannel channel) throws CommandException {
        List commands = this.commandManager.getCommands().stream().map(cmd -> {
            Permission min = cmd.getMinimumPermission();
            if (this.permissionManager.has(author, this.discordChat.getJDA().getGuildById(this.config.getServerID()), min)) {
                return "**" + cmd.getName() + "**";
            }
            return cmd.getName();
        }).collect(Collectors.toList());
        String msg = "Commands (you have permission for **bolded** ones):\n" + String.join((CharSequence)", ", commands);
        this.sendResponse(msg, channel, this.discordChat);
    }

    @Override
    public String getDescription() {
        return "Lists all available commands";
    }

    @Override
    public String getUsage() {
        return "";
    }
}

