/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.numbers;

import cofh.lib.util.numbers.INumberProvider;
import java.util.Locale;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OperationProvider
implements INumberProvider {
    protected final INumberProvider valueA;
    protected final INumberProvider valueB;
    protected final Operation operation;
    protected final long min;
    protected final long max;

    public OperationProvider(INumberProvider valueA, INumberProvider valueB, String type, long min, long max) {
        this.valueA = valueA;
        this.valueB = valueB;
        this.operation = Operation.valueOf(type.toUpperCase(Locale.US));
        this.min = min;
        this.max = max;
    }

    @Override
    public int intValue(World world, Random rand, BlockPos pos) {
        return (int)this.longValue(world, rand, pos);
    }

    @Override
    public long longValue(World world, Random rand, BlockPos pos) {
        return Math.min(Math.max(this.operation.perform(this.valueA.longValue(world, rand, pos), this.valueB.longValue(world, rand, pos)), this.min), this.max);
    }

    @Override
    public float floatValue(World world, Random rand, BlockPos pos) {
        return (float)this.doubleValue(world, rand, pos);
    }

    @Override
    public double doubleValue(World world, Random rand, BlockPos pos) {
        return Math.min(Math.max(this.operation.perform(this.valueA.doubleValue(world, rand, pos), this.valueB.doubleValue(world, rand, pos)), (double)this.min), (double)this.max);
    }

    private static enum Operation {
        ADD{

            @Override
            public long perform(long a, long b) {
                return a + b;
            }

            @Override
            public double perform(double a, double b) {
                return a + b;
            }
        }
        ,
        SUBTRACT{

            @Override
            public long perform(long a, long b) {
                return a - b;
            }

            @Override
            public double perform(double a, double b) {
                return a - b;
            }
        }
        ,
        MULTIPLY{

            @Override
            public long perform(long a, long b) {
                return a * b;
            }

            @Override
            public double perform(double a, double b) {
                return a * b;
            }
        }
        ,
        DIVIDE{

            @Override
            public long perform(long a, long b) {
                return a / b;
            }

            @Override
            public double perform(double a, double b) {
                return a / b;
            }
        }
        ,
        MODULO{

            @Override
            public long perform(long a, long b) {
                return a % b;
            }

            @Override
            public double perform(double a, double b) {
                return a % b;
            }
        };


        public abstract long perform(long var1, long var3);

        public abstract double perform(double var1, double var3);
    }
}

