/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class NBTHelper {
    private NBTHelper() {
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean keyExists(ItemStack stack, String key) {
        if (stack == null) {
            return false;
        }
        return NBTHelper.getTagCompound(stack).func_74764_b(key);
    }

    public static int getInt(ItemStack stack, String key, int defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74762_e(key);
    }

    public static void setInt(ItemStack stack, String key, int value) {
        NBTHelper.getTagCompound(stack).func_74768_a(key, value);
    }

    public static long getLong(ItemStack stack, String key, long defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74763_f(key);
    }

    public static void setLong(ItemStack stack, String key, Long value) {
        NBTHelper.getTagCompound(stack).func_74772_a(key, value.longValue());
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74767_n(key);
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        NBTHelper.getTagCompound(stack).func_74757_a(key, value);
    }

    public static byte getByte(ItemStack stack, String key, byte defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74771_c(key);
    }

    public static void setByte(ItemStack stack, String key, byte value) {
        NBTHelper.getTagCompound(stack).func_74774_a(key, value);
    }

    public static byte[] getByteArray(ItemStack stack, String key, byte[] defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74770_j(key);
    }

    public static void setByteArray(ItemStack stack, String key, byte[] value) {
        NBTHelper.getTagCompound(stack).func_74773_a(key, value);
    }

    public static double getDouble(ItemStack stack, String key, double defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74769_h(key);
    }

    public static void setDouble(ItemStack stack, String key, double value) {
        NBTHelper.getTagCompound(stack).func_74780_a(key, value);
    }

    public static float getFloat(ItemStack stack, String key, float defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74760_g(key);
    }

    public static void setFloat(ItemStack stack, String key, float value) {
        NBTHelper.getTagCompound(stack).func_74776_a(key, value);
    }

    public static int[] getIntArray(ItemStack stack, String key, int[] defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74759_k(key);
    }

    public static void setIntArray(ItemStack stack, String key, int[] value) {
        NBTHelper.getTagCompound(stack).func_74783_a(key, value);
    }

    public static short getShort(ItemStack stack, String key, short defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74765_d(key);
    }

    public static void setShort(ItemStack stack, String key, short value) {
        NBTHelper.getTagCompound(stack).func_74777_a(key, value);
    }

    public static String getString(ItemStack stack, String key, String defaultValue) {
        if (!NBTHelper.keyExists(stack, key)) {
            return defaultValue;
        }
        return NBTHelper.getTagCompound(stack).func_74779_i(key);
    }

    public static void setString(ItemStack stack, String key, String value) {
        NBTHelper.getTagCompound(stack).func_74778_a(key, value);
    }

    public static NBTBase getTag(ItemStack stack, String key) {
        if (!NBTHelper.keyExists(stack, key)) {
            return null;
        }
        return NBTHelper.getTagCompound(stack).func_74781_a(key);
    }

    public static void setTag(ItemStack stack, String key, NBTBase value) {
        NBTHelper.getTagCompound(stack).func_74782_a(key, value);
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack, String key) {
        if (!NBTHelper.keyExists(stack, key)) {
            return null;
        }
        return NBTHelper.getTagCompound(stack).func_74775_l(key);
    }

    public static void removeTag(ItemStack stack, String key) {
        NBTHelper.getTagCompound(stack).func_82580_o(key);
    }
}

