/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.lib.util.OreDictionaryProxy;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class ItemHelper {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String DUST = "dust";
    public static final String INGOT = "ingot";
    public static final String NUGGET = "nugget";
    public static final String LOG = "log";
    public static OreDictionaryProxy oreProxy = new OreDictionaryProxy();

    private ItemHelper() {
    }

    public static boolean isPlayerHoldingSomething(EntityPlayer player) {
        return player.func_184614_ca() != null || player.func_184592_cb() != null;
    }

    public static ItemStack getMainhandStack(EntityPlayer player) {
        return player.func_184614_ca();
    }

    public static ItemStack getOffhandStack(EntityPlayer player) {
        return player.func_184592_cb();
    }

    public static ItemStack getHeldStack(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack == null) {
            stack = player.func_184592_cb();
        }
        return stack;
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return null;
        }
        return new ItemStack(item, stackSize);
    }

    public static ItemStack cloneStack(Block item, int stackSize) {
        if (item == null) {
            return null;
        }
        return new ItemStack(item, stackSize);
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack == null) {
            return null;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.field_77994_a = stackSize;
        return retStack;
    }

    public static ItemStack cloneStack(ItemStack stack) {
        return stack == null ? null : stack.func_77946_l();
    }

    public static ItemStack copyTag(ItemStack container, ItemStack other) {
        if (other != null && other.func_77942_o()) {
            container.func_77982_d(other.func_77978_p().func_74737_b());
        }
        return container;
    }

    public static NBTTagCompound setItemStackTagName(NBTTagCompound tag, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (!tag.func_74764_b("display")) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        tag.func_74775_l("display").func_74778_a("Name", name);
        return tag;
    }

    public static ItemStack readItemStackFromNBT(NBTTagCompound nbt) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)nbt.func_74765_d("id")));
        stack.field_77994_a = nbt.func_74762_e("Count");
        stack.func_77964_b(Math.max(0, nbt.func_74765_d("Damage")));
        if (nbt.func_150297_b("tag", 10)) {
            stack.func_77982_d(nbt.func_74775_l("tag"));
        }
        return stack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", stack.field_77994_a);
        nbt.func_74777_a("Damage", (short)ItemHelper.getItemDamage(stack));
        if (stack.func_77942_o()) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return nbt;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, int amount, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", amount);
        nbt.func_74777_a("Damage", (short)ItemHelper.getItemDamage(stack));
        if (stack.func_77942_o()) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return nbt;
    }

    public static String getNameFromItemStack(ItemStack stack) {
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("display")) {
            return "";
        }
        return stack.func_77978_p().func_74775_l("display").func_74779_i("Name");
    }

    public static ItemStack damageItem(ItemStack stack, int amt, Random rand) {
        if (stack != null && stack.func_77984_f() && stack.func_96631_a(amt, rand)) {
            if (--stack.field_77994_a <= 0) {
                stack = null;
            } else {
                stack.func_77964_b(0);
            }
        }
        return stack;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        boolean largerStack;
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.field_77994_a > 1;
        if (largerStack) {
            --stack.field_77994_a;
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret == null) {
                return null;
            }
            if (ret.func_77984_f() && ret.func_77952_i() > ret.func_77958_k()) {
                ret = null;
            }
            return ret;
        }
        return largerStack ? stack : null;
    }

    public static ItemStack consumeItem(ItemStack stack, EntityPlayer player) {
        boolean largerStack;
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.field_77994_a > 1;
        if (largerStack) {
            --stack.field_77994_a;
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret == null || ret.func_77984_f() && ret.func_77952_i() > ret.func_77958_k()) {
                ret = null;
            }
            if (stack.field_77994_a < 1) {
                return ret;
            }
            if (ret != null && !player.field_71071_by.func_70441_a(ret)) {
                player.func_146097_a(ret, false, true);
            }
        }
        return largerStack ? stack : null;
    }

    public static boolean disposePlayerItem(ItemStack stack, ItemStack dropStack, EntityPlayer entityplayer, boolean allowDrop) {
        return ItemHelper.disposePlayerItem(stack, dropStack, entityplayer, allowDrop, true);
    }

    public static boolean disposePlayerItem(ItemStack stack, ItemStack dropStack, EntityPlayer entityplayer, boolean allowDrop, boolean allowReplace) {
        if (entityplayer == null || entityplayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (allowReplace && stack.field_77994_a <= 1) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            entityplayer.field_71071_by.func_70441_a(dropStack);
            return true;
        }
        if (allowDrop) {
            --stack.field_77994_a;
            if (dropStack != null && !entityplayer.field_71071_by.func_70441_a(dropStack)) {
                entityplayer.func_146097_a(dropStack, false, true);
            }
            return true;
        }
        return false;
    }

    public static int getItemDamage(ItemStack stack) {
        return Items.field_151045_i.getDamage(stack);
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        ItemStack[] dmgItems = new ItemStack[2];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            if (dmgItems[0] == null) {
                dmgItems[0] = inv.func_70301_a(i);
                continue;
            }
            dmgItems[1] = inv.func_70301_a(i);
            break;
        }
        if (dmgItems[0] == null || dmgItems[0].func_77973_b() == null) {
            return null;
        }
        if (dmgItems[1] != null && dmgItems[0].func_77973_b() == dmgItems[1].func_77973_b() && dmgItems[0].field_77994_a == 1 && dmgItems[1].field_77994_a == 1 && dmgItems[0].func_77973_b().isRepairable()) {
            Item theItem = dmgItems[0].func_77973_b();
            int var13 = theItem.func_77612_l() - dmgItems[0].func_77952_i();
            int var8 = theItem.func_77612_l() - dmgItems[1].func_77952_i();
            int var9 = var13 + var8 + theItem.func_77612_l() * 5 / 100;
            int var10 = Math.max(0, theItem.func_77612_l() - var9);
            return new ItemStack(dmgItems[0].func_77973_b(), 1, var10);
        }
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe.func_77572_b(inv);
        }
        return null;
    }

    public static ItemStack getOre(String oreName) {
        return oreProxy.getOre(oreName);
    }

    public static String getOreName(ItemStack stack) {
        return oreProxy.getOreName(stack);
    }

    public static boolean isOreIDEqual(ItemStack stack, int oreID) {
        return oreProxy.isOreIDEqual(stack, oreID);
    }

    public static boolean isOreNameEqual(ItemStack stack, String oreName) {
        return oreProxy.isOreNameEqual(stack, oreName);
    }

    public static boolean oreNameExists(String oreName) {
        return oreProxy.oreNameExists(oreName);
    }

    public static boolean hasOreName(ItemStack stack) {
        return !ItemHelper.getOreName(stack).equals("Unknown");
    }

    public static boolean isBlock(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(BLOCK);
    }

    public static boolean isOre(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(ORE);
    }

    public static boolean isDust(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(DUST);
    }

    public static boolean isIngot(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(INGOT);
    }

    public static boolean isNugget(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(NUGGET);
    }

    public static boolean isLog(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(LOG);
    }

    public static ItemStack stack(Item t) {
        return new ItemStack(t);
    }

    public static ItemStack stack(Item t, int s) {
        return new ItemStack(t, s);
    }

    public static ItemStack stack(Item t, int s, int m) {
        return new ItemStack(t, s, m);
    }

    public static ItemStack stack(Block t) {
        return new ItemStack(t);
    }

    public static ItemStack stack(Block t, int s) {
        return new ItemStack(t, s);
    }

    public static ItemStack stack(Block t, int s, int m) {
        return new ItemStack(t, s, m);
    }

    public static ItemStack stack2(Item t) {
        return new ItemStack(t, 1, Short.MAX_VALUE);
    }

    public static ItemStack stack2(Item t, int s) {
        return new ItemStack(t, s, Short.MAX_VALUE);
    }

    public static ItemStack stack2(Block t) {
        return new ItemStack(t, 1, Short.MAX_VALUE);
    }

    public static ItemStack stack2(Block t, int s) {
        return new ItemStack(t, s, Short.MAX_VALUE);
    }

    public static IRecipe ShapedRecipe(Block result, Object ... recipe) {
        return new ShapedOreRecipe(result, recipe);
    }

    public static IRecipe ShapedRecipe(Item result, Object ... recipe) {
        return new ShapedOreRecipe(result, recipe);
    }

    public static IRecipe ShapedRecipe(ItemStack result, Object ... recipe) {
        return new ShapedOreRecipe(result, recipe);
    }

    public static IRecipe ShapedRecipe(Block result, int s, Object ... recipe) {
        return new ShapedOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static IRecipe ShapedRecipe(Item result, int s, Object ... recipe) {
        return new ShapedOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static IRecipe ShapedRecipe(ItemStack result, int s, Object ... recipe) {
        return new ShapedOreRecipe(ItemHelper.cloneStack(result, s), recipe);
    }

    public static IRecipe ShapelessRecipe(Block result, Object ... recipe) {
        return new ShapelessOreRecipe(result, recipe);
    }

    public static IRecipe ShapelessRecipe(Item result, Object ... recipe) {
        return new ShapelessOreRecipe(result, recipe);
    }

    public static IRecipe ShapelessRecipe(ItemStack result, Object ... recipe) {
        return new ShapelessOreRecipe(result, recipe);
    }

    public static IRecipe ShapelessRecipe(Block result, int s, Object ... recipe) {
        return new ShapelessOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static IRecipe ShapelessRecipe(Item result, int s, Object ... recipe) {
        return new ShapelessOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static IRecipe ShapelessRecipe(ItemStack result, int s, Object ... recipe) {
        return new ShapelessOreRecipe(ItemHelper.cloneStack(result, s), recipe);
    }

    public static boolean addGearRecipe(ItemStack gear, String ingot) {
        if (gear == null || !ItemHelper.oreNameExists(ingot)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(gear, " X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), "ingotIron"));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, String ingot, String center) {
        if (gear == null || !ItemHelper.oreNameExists(ingot) || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(gear, " X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, String ingot, ItemStack center) {
        if (gear == null | center == null || !ItemHelper.oreNameExists(ingot)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(gear, " X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, ItemStack ingot, String center) {
        if (gear == null | ingot == null || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(gear, " X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, ItemStack ingot, ItemStack center) {
        if (gear == null | ingot == null | center == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(gear), (Object[])new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ItemHelper.cloneStack(ingot, 1), Character.valueOf('I'), ItemHelper.cloneStack(center, 1)});
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, String ingot, String center) {
        if (gear == null || !ItemHelper.oreNameExists(ingot) || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(gear, "X X", " I ", "X X", Character.valueOf('X'), ingot, Character.valueOf('I'), center));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, String ingot, ItemStack center) {
        if (gear == null | center == null || !ItemHelper.oreNameExists(ingot)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(gear, "X X", " I ", "X X", Character.valueOf('X'), ingot, Character.valueOf('I'), center));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, ItemStack ingot, String center) {
        if (gear == null | ingot == null || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(gear, "X X", " I ", "X X", Character.valueOf('X'), ingot, Character.valueOf('I'), center));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, ItemStack ingot, ItemStack center) {
        if (gear == null | ingot == null | center == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(gear), (Object[])new Object[]{"X X", " I ", "X X", Character.valueOf('X'), ItemHelper.cloneStack(ingot, 1), Character.valueOf('I'), ItemHelper.cloneStack(center, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, ItemStack one, ItemStack eight) {
        if (out == null | one == null | eight == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(out), (Object[])new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(eight, 1), Character.valueOf('I'), ItemHelper.cloneStack(one, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, String one, ItemStack eight) {
        if (out == null | eight == null || !ItemHelper.oreNameExists(one)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, "XXX", "XIX", "XXX", Character.valueOf('X'), eight, Character.valueOf('I'), one));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, ItemStack one, String eight) {
        if (out == null | one == null || !ItemHelper.oreNameExists(eight)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, "XXX", "XIX", "XXX", Character.valueOf('X'), eight, Character.valueOf('I'), one));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, String one, String eight) {
        if (out == null || !ItemHelper.oreNameExists(one) || !ItemHelper.oreNameExists(eight)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, "XXX", "XIX", "XXX", Character.valueOf('X'), eight, Character.valueOf('I'), one));
        return true;
    }

    public static boolean addFenceRecipe(ItemStack out, ItemStack in) {
        if (out == null | in == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(out), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(in, 1)});
        return true;
    }

    public static boolean addFenceRecipe(ItemStack out, String in) {
        if (out == null || !ItemHelper.oreNameExists(in)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, "XXX", "XXX", Character.valueOf('X'), in));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack nine, String one) {
        if (nine == null || !ItemHelper.oreNameExists(one)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(ItemHelper.cloneStack(nine, 9), one));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack nine, ItemStack one) {
        if (nine == null | one == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(nine, 9), (Object[])new Object[]{ItemHelper.cloneStack(one, 1)});
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack four, String one) {
        if (four == null || !ItemHelper.oreNameExists(one)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(ItemHelper.cloneStack(four, 4), one));
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack four, ItemStack one) {
        if (four == null | one == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(four, 4), (Object[])new Object[]{ItemHelper.cloneStack(one, 1)});
        return true;
    }

    public static boolean addStorageRecipe(ItemStack one, String nine) {
        if (one == null || !ItemHelper.oreNameExists(nine)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(one, nine, nine, nine, nine, nine, nine, nine, nine, nine));
        return true;
    }

    public static boolean addStorageRecipe(ItemStack one, ItemStack nine) {
        if (one == null | nine == null) {
            return false;
        }
        nine = ItemHelper.cloneStack(nine, 1);
        GameRegistry.addShapelessRecipe((ItemStack)one, (Object[])new Object[]{nine, nine, nine, nine, nine, nine, nine, nine, nine});
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack one, String four) {
        if (one == null || !ItemHelper.oreNameExists(four)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(one, "XX", "XX", Character.valueOf('X'), four));
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack one, ItemStack four) {
        if (one == null | four == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(one), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ItemHelper.cloneStack(four, 1)});
        return true;
    }

    public static boolean addTwoWayStorageRecipe(ItemStack one, ItemStack nine) {
        return ItemHelper.addStorageRecipe(one, nine) && ItemHelper.addReverseStorageRecipe(nine, one);
    }

    public static boolean addTwoWayStorageRecipe(ItemStack one, String one_ore, ItemStack nine, String nine_ore) {
        return ItemHelper.addStorageRecipe(one, nine_ore) && ItemHelper.addReverseStorageRecipe(nine, one_ore);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack one, ItemStack four) {
        return ItemHelper.addSmallStorageRecipe(one, four) && ItemHelper.addSmallReverseStorageRecipe(four, one);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack one, String one_ore, ItemStack four, String four_ore) {
        return ItemHelper.addSmallStorageRecipe(one, four_ore) && ItemHelper.addSmallReverseStorageRecipe(four, one_ore);
    }

    public static boolean addSmelting(ItemStack out, Item in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack out, Block in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack out, ItemStack in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack out, Item in, float XP) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), XP);
        return true;
    }

    public static boolean addSmelting(ItemStack out, Block in, float XP) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), XP);
        return true;
    }

    public static boolean addSmelting(ItemStack out, ItemStack in, float XP) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), XP);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack out, Item in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack out, Block in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack out, ItemStack in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.1f);
        return true;
    }

    public static boolean addTwoWayConversionRecipe(ItemStack a, ItemStack b) {
        if (a == null | b == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(a, 1), (Object[])new Object[]{ItemHelper.cloneStack(b, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(b, 1), (Object[])new Object[]{ItemHelper.cloneStack(a, 1)});
        return true;
    }

    public static void registerWithHandlers(String oreName, ItemStack stack) {
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)stack);
    }

    public static void addRecipe(IRecipe recipe) {
        GameRegistry.addRecipe((IRecipe)recipe);
    }

    public static void addRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((ItemStack)out, (Object[])recipe);
    }

    public static void addShapedRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((ItemStack)out, (Object[])recipe);
    }

    public static void addShapedRecipe(Item out, Object ... recipe) {
        ItemHelper.addRecipe(new ItemStack(out), recipe);
    }

    public static void addShapedRecipe(Block out, Object ... recipe) {
        ItemHelper.addRecipe(new ItemStack(out), recipe);
    }

    public static void addShapelessRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addShapelessRecipe((ItemStack)out, (Object[])recipe);
    }

    public static void addShapelessRecipe(Item out, Object ... recipe) {
        ItemHelper.addShapelessRecipe(new ItemStack(out), recipe);
    }

    public static void addShapelessRecipe(Block out, Object ... recipe) {
        ItemHelper.addShapelessRecipe(new ItemStack(out), recipe);
    }

    public static void addShapedOreRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, recipe));
    }

    public static void addShapedOreRecipe(Item out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, recipe));
    }

    public static void addShapedOreRecipe(Block out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, recipe));
    }

    public static void addShapelessOreRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(out, recipe));
    }

    public static void addShapelessOreRecipe(Item out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(out, recipe));
    }

    public static void addShapelessOreRecipe(Block out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(out, recipe));
    }

    public static boolean isPlayerHoldingMultiModeItem(EntityPlayer player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack heldItem = ItemHelper.getHeldStack(player);
        Item equipped = heldItem.func_77973_b();
        return equipped instanceof IMultiModeItem;
    }

    public static boolean incrHeldMultiModeItemState(EntityPlayer player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack heldItem = ItemHelper.getHeldStack(player);
        Item equipped = heldItem.func_77973_b();
        IMultiModeItem multiModeItem = (IMultiModeItem)equipped;
        return multiModeItem.incrMode(heldItem);
    }

    public static boolean decrHeldMultiModeItemState(EntityPlayer player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack equipped = ItemHelper.getHeldStack(player);
        IMultiModeItem multiModeItem = (IMultiModeItem)equipped.func_77973_b();
        return multiModeItem.incrMode(equipped);
    }

    public static boolean setHeldMultiModeItemState(EntityPlayer player, int mode) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack equipped = ItemHelper.getHeldStack(player);
        IMultiModeItem multiModeItem = (IMultiModeItem)equipped.func_77973_b();
        return multiModeItem.setMode(equipped, mode);
    }

    public static boolean isPlayerHoldingFluidHandler(EntityPlayer player) {
        return FluidHelper.isPlayerHoldingFluidHandler(player);
    }

    public static boolean isPlayerHoldingEnergyContainerItem(EntityPlayer player) {
        return EnergyHelper.isPlayerHoldingEnergyContainerItem(player);
    }

    public static boolean isPlayerHoldingNothing(EntityPlayer player) {
        return ItemHelper.getHeldStack(player) == null;
    }

    public static Item getItemFromStack(ItemStack theStack) {
        return theStack == null ? null : theStack.func_77973_b();
    }

    public static boolean areItemsEqual(Item itemA, Item itemB) {
        if (itemA == null | itemB == null) {
            return false;
        }
        return itemA == itemB || itemA.equals(itemB);
    }

    public static boolean isPlayerHoldingItem(Class<?> item, EntityPlayer player) {
        return item.isInstance(ItemHelper.getItemFromStack(ItemHelper.getHeldStack(player)));
    }

    public static boolean isPlayerHoldingItem(Item item, EntityPlayer player) {
        return ItemHelper.areItemsEqual(item, ItemHelper.getItemFromStack(ItemHelper.getHeldStack(player)));
    }

    public static boolean isPlayerHoldingMainhand(Item item, EntityPlayer player) {
        return ItemHelper.areItemsEqual(item, ItemHelper.getItemFromStack(ItemHelper.getMainhandStack(player)));
    }

    public static boolean isPlayerHoldingOffhand(Item item, EntityPlayer player) {
        return ItemHelper.areItemsEqual(item, ItemHelper.getItemFromStack(ItemHelper.getOffhandStack(player)));
    }

    public static boolean isPlayerHoldingItemStack(ItemStack stack, EntityPlayer player) {
        return ItemHelper.itemsEqualWithMetadata(stack, ItemHelper.getHeldStack(player));
    }

    public static boolean itemsDamageEqual(ItemStack stackA, ItemStack stackB) {
        return !stackA.func_77981_g() && stackA.func_77958_k() == 0 || ItemHelper.getItemDamage(stackA) == ItemHelper.getItemDamage(stackB);
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB) {
        if (stackA == null || stackB == null) {
            return false;
        }
        return ItemHelper.areItemsEqual(stackA.func_77973_b(), stackB.func_77973_b());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && (!checkNBT || ItemHelper.doNBTsMatch(stackA.func_77978_p(), stackB.func_77978_p()));
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && ItemHelper.itemsDamageEqual(stackA, stackB);
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return ItemHelper.itemsEqualWithMetadata(stackA, stackB) && (!checkNBT || ItemHelper.doNBTsMatch(stackA.func_77978_p(), stackB.func_77978_p()));
    }

    public static boolean itemsIdentical(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && ItemHelper.getItemDamage(stackA) == ItemHelper.getItemDamage(stackB) && ItemHelper.doNBTsMatch(stackA.func_77978_p(), stackB.func_77978_p());
    }

    public static boolean doNBTsMatch(NBTTagCompound nbtA, NBTTagCompound nbtB) {
        if (nbtA == null & nbtB == null) {
            return true;
        }
        if (nbtA != null & nbtB != null) {
            return nbtA.equals((Object)nbtB);
        }
        return false;
    }

    public static boolean itemsEqualForCrafting(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && (!stackA.func_77981_g() || ItemHelper.getItemDamage(stackA) == Short.MAX_VALUE || ItemHelper.getItemDamage(stackB) == Short.MAX_VALUE || ItemHelper.getItemDamage(stackB) == ItemHelper.getItemDamage(stackA));
    }

    public static boolean craftingEquivalent(ItemStack checked, ItemStack source, String oreDict, ItemStack output) {
        if (ItemHelper.itemsEqualForCrafting(checked, source)) {
            return true;
        }
        if (output != null && ItemHelper.isBlacklist(output)) {
            return false;
        }
        if (oreDict == null || oreDict.equals("Unknown")) {
            return false;
        }
        return ItemHelper.getOreName(checked).equalsIgnoreCase(oreDict);
    }

    public static boolean doOreIDsMatch(ItemStack stackA, ItemStack stackB) {
        int id = oreProxy.getOreID(stackA);
        return id >= 0 && id == oreProxy.getOreID(stackB);
    }

    public static boolean isBlacklist(ItemStack output) {
        Item item = output.func_77973_b();
        return Item.func_150898_a((Block)Blocks.field_150487_bG) == item || Item.func_150898_a((Block)Blocks.field_150481_bH) == item || Item.func_150898_a((Block)Blocks.field_150476_ad) == item || Item.func_150898_a((Block)Blocks.field_150485_bF) == item || Item.func_150898_a((Block)Blocks.field_150344_f) == item || Item.func_150898_a((Block)Blocks.field_150376_bx) == item;
    }

    public static String getItemNBTString(ItemStack theItem, String nbtKey, String invalidReturn) {
        return theItem.func_77978_p() != null && theItem.func_77978_p().func_74764_b(nbtKey) ? theItem.func_77978_p().func_74779_i(nbtKey) : invalidReturn;
    }

    public static void addInventoryInformation(ItemStack stack, List<String> list) {
        ItemHelper.addInventoryInformation(stack, list, 0, Integer.MAX_VALUE);
    }

    public static void addInventoryInformation(ItemStack stack, List<String> list, int minSlot, int maxSlot) {
        if (stack.func_77978_p() == null) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        if (stack.func_77973_b() instanceof IInventoryContainerItem && stack.func_77978_p().func_74764_b("Accessible")) {
            ItemHelper.addAccessibleInventoryInformation(stack, list, minSlot, maxSlot);
            return;
        }
        if (!stack.func_77978_p().func_150297_b("Inventory", 9) || stack.func_77978_p().func_150295_c("Inventory", (int)stack.func_77978_p().func_74732_a()).func_74745_c() <= 0) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        NBTTagList nbtList = stack.func_77978_p().func_150295_c("Inventory", (int)stack.func_77978_p().func_74732_a());
        ArrayList<ItemStack> containedItems = new ArrayList<ItemStack>();
        boolean[] visited = new boolean[nbtList.func_74745_c()];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtList.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (visited[i] || slot < minSlot || slot > maxSlot) continue;
            visited[i] = true;
            ItemStack curStack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (curStack == null) continue;
            containedItems.add(curStack);
            for (int j = 0; j < nbtList.func_74745_c(); ++j) {
                ItemStack curStack2;
                NBTTagCompound tag2 = nbtList.func_150305_b(j);
                int slot2 = tag.func_74762_e("Slot");
                if (visited[j] || slot2 < minSlot || slot2 > maxSlot || (curStack2 = ItemStack.func_77949_a((NBTTagCompound)tag2)) == null || !ItemHelper.itemsIdentical(curStack, curStack2)) continue;
                curStack.field_77994_a += curStack2.field_77994_a;
                visited[j] = true;
            }
        }
        if (containedItems.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        }
        for (ItemStack item : containedItems) {
            int maxStackSize = item.func_77976_d();
            if (!StringHelper.displayStackCount || item.field_77994_a < maxStackSize || maxStackSize == 1) {
                list.add("    \u00a76" + item.field_77994_a + " " + StringHelper.getItemName(item));
                continue;
            }
            if (item.field_77994_a % maxStackSize != 0) {
                list.add("    \u00a76" + maxStackSize + "x" + item.field_77994_a / maxStackSize + "+" + item.field_77994_a % maxStackSize + " " + StringHelper.getItemName(item));
                continue;
            }
            list.add("    \u00a76" + maxStackSize + "x" + item.field_77994_a / maxStackSize + " " + StringHelper.getItemName(item));
        }
    }

    public static void addAccessibleInventoryInformation(ItemStack stack, List<String> list, int minSlot, int maxSlot) {
        int invSize = ((IInventoryContainerItem)stack.func_77973_b()).getSizeInventory(stack);
        ArrayList<ItemStack> containedItems = new ArrayList<ItemStack>();
        boolean[] visited = new boolean[invSize];
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b("Inventory")) {
            tag = tag.func_74775_l("Inventory");
        }
        for (int i = minSlot; i < Math.min(invSize, maxSlot); ++i) {
            if (visited[i] || !tag.func_74764_b("Slot" + i)) continue;
            ItemStack curStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Slot" + i));
            visited[i] = true;
            if (curStack == null) continue;
            containedItems.add(curStack);
            for (int j = minSlot; j < Math.min(invSize, maxSlot); ++j) {
                ItemStack curStack2;
                if (visited[j] || !tag.func_74764_b("Slot" + j) || (curStack2 = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Slot" + j))) == null || !ItemHelper.itemsIdentical(curStack, curStack2)) continue;
                curStack.field_77994_a += curStack2.field_77994_a;
                visited[j] = true;
            }
        }
        if (containedItems.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        } else {
            list.add(StringHelper.localize("info.cofh.empty"));
        }
        for (ItemStack item : containedItems) {
            int maxStackSize = item.func_77976_d();
            if (!StringHelper.displayStackCount || item.field_77994_a < maxStackSize || maxStackSize == 1) {
                list.add("    \u00a76" + item.field_77994_a + " " + StringHelper.getItemName(item));
                continue;
            }
            if (item.field_77994_a % maxStackSize != 0) {
                list.add("    \u00a76" + maxStackSize + "x" + item.field_77994_a / maxStackSize + "+" + item.field_77994_a % maxStackSize + " " + StringHelper.getItemName(item));
                continue;
            }
            list.add("    \u00a76" + maxStackSize + "x" + item.field_77994_a / maxStackSize + " " + StringHelper.getItemName(item));
        }
    }

    public static boolean areItemStacksEqualIgnoreTags(ItemStack stackA, ItemStack stackB, String ... nbtTagsToIgnore) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA == null && stackB != null) {
            return false;
        }
        if (stackA != null && stackB == null) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        if (stackA.field_77994_a != stackB.field_77994_a) {
            return false;
        }
        if (stackA.func_77978_p() == null && stackB.func_77978_p() == null) {
            return true;
        }
        if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
            return false;
        }
        if (stackA.func_77978_p() != null && stackB.func_77978_p() == null) {
            return false;
        }
        int numberOfKeys = stackA.func_77978_p().func_150296_c().size();
        if (numberOfKeys != stackB.func_77978_p().func_150296_c().size()) {
            return false;
        }
        NBTTagCompound tagA = stackA.func_77978_p();
        NBTTagCompound tagB = stackB.func_77978_p();
        String[] keys = new String[numberOfKeys];
        keys = tagA.func_150296_c().toArray(keys);
        block0: for (int i = 0; i < numberOfKeys; ++i) {
            for (int j = 0; j < nbtTagsToIgnore.length; ++j) {
                if (nbtTagsToIgnore[j].equals(keys[i])) continue block0;
            }
            if (tagA.func_74781_a(keys[i]).equals((Object)tagB.func_74781_a(keys[i]))) continue;
            return false;
        }
        return true;
    }
}

