/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementButtonBase;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class ElementButton
extends ElementButtonBase {
    private int sheetX;
    private int sheetY;
    private int hoverX;
    private int hoverY;
    private int disabledX = 0;
    private int disabledY = 0;
    private boolean tooltipLocalized = false;
    private boolean managedClicks;
    private String tooltip;

    public ElementButton(GuiBase gui, int posX, int posY, int sizeX, int sizeY, int sheetX, int sheetY, int hoverX, int hoverY, String texture) {
        super(gui, posX, posY, sizeX, sizeY);
        this.setGuiManagedClicks(false);
        this.setTexture(texture, this.texW, this.texH);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
    }

    public ElementButton(GuiBase gui, int posX, int posY, int sizeX, int sizeY, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, String texture) {
        this(gui, posX, posY, sizeX, sizeY, sheetX, sheetY, hoverX, hoverY, texture);
        this.disabledX = disabledX;
        this.disabledY = disabledY;
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, String texture) {
        super(gui, posX, posY, sizeX, sizeY);
        this.setGuiManagedClicks(true);
        this.setName(name);
        this.setTexture(texture, this.texW, this.texH);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, int sizeX, int sizeY, String texture) {
        this(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, sizeX, sizeY, texture);
        this.disabledX = disabledX;
        this.disabledY = disabledY;
    }

    public ElementButton setGuiManagedClicks(boolean managed) {
        this.managedClicks = managed;
        return this;
    }

    public ElementButton clearToolTip() {
        this.tooltip = null;
        return this;
    }

    public ElementButton setToolTip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ElementButton setToolTipLocalized(boolean localized) {
        this.tooltipLocalized = localized;
        return this;
    }

    public ElementButton setToolTipLocalized(String tooltip) {
        return this.setToolTip(tooltip).setToolTipLocalized(true);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.bindTexture(this.texture);
        if (this.isEnabled()) {
            if (this.intersectsWith(mouseX, mouseY)) {
                this.drawTexturedModalRect(this.posX, this.posY, this.hoverX, this.hoverY, this.sizeX, this.sizeY);
            } else {
                this.drawTexturedModalRect(this.posX, this.posY, this.sheetX, this.sheetY, this.sizeX, this.sizeY);
            }
        } else {
            this.drawTexturedModalRect(this.posX, this.posY, this.disabledX, this.disabledY, this.sizeX, this.sizeY);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tooltip != null) {
            if (this.tooltipLocalized) {
                list.add(this.tooltip);
            } else {
                list.add(StringHelper.localize(this.tooltip));
            }
        }
    }

    @Override
    public void onClick() {
    }

    @Override
    public boolean onMousePressed(int x, int y, int mouseButton) {
        if (!this.managedClicks) {
            return super.onMousePressed(x, y, mouseButton);
        }
        if (this.isEnabled()) {
            this.gui.handleElementButtonClick(this.getName(), mouseButton);
            return true;
        }
        return false;
    }

    public void setSheetX(int pos) {
        this.sheetX = pos;
    }

    public void setSheetY(int pos) {
        this.sheetY = pos;
    }

    public void setHoverX(int pos) {
        this.hoverX = pos;
    }

    public void setHoverY(int pos) {
        this.hoverY = pos;
    }

    public ElementButton setDisabledX(int pos) {
        this.disabledX = pos;
        return this;
    }

    public ElementButton setDisabledY(int pos) {
        this.disabledY = pos;
        return this;
    }

    public void setActive() {
        this.setEnabled(true);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }
}

