/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.container;

import cofh.api.item.IInventoryContainerItem;
import cofh.lib.gui.container.ContainerInventoryItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryContainerItemWrapper
implements IInventory {
    protected final IInventoryContainerItem inventoryItem;
    protected final ItemStack stack;
    protected NBTTagCompound tag;
    protected ItemStack[] inventory;
    protected boolean dirty = false;

    @Deprecated
    public InventoryContainerItemWrapper(ContainerInventoryItem gui, ItemStack stack) {
        this(stack);
    }

    public InventoryContainerItemWrapper(ItemStack itemstack) {
        this.stack = itemstack;
        this.inventoryItem = (IInventoryContainerItem)this.stack.func_77973_b();
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.loadInventory();
        this.func_70296_d();
    }

    protected void loadInventory() {
        boolean loaded = false;
        if (!this.stack.func_77942_o() || !this.stack.func_77978_p().func_74764_b("Inventory")) {
            loaded = this.stack.func_77942_o();
            if (loaded) {
                if (this.stack.func_77978_p().func_74764_b("inventory")) {
                    this.tag = this.stack.func_77978_p().func_74775_l("inventory");
                    this.stack.func_77978_p().func_82580_o("inventory");
                } else {
                    this.tag = this.stack.func_77978_p();
                }
                this.loadStacks();
                this.tag = new NBTTagCompound();
                this.saveStacks();
            } else {
                this.stack.func_77983_a("Inventory", (NBTBase)new NBTTagCompound());
            }
        }
        this.tag = this.stack.func_77978_p().func_74775_l("Inventory");
        this.loadStacks();
    }

    protected void loadStacks() {
        int i = this.inventory.length;
        while (i-- > 0) {
            if (this.tag.func_74764_b("Slot" + i)) {
                this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)this.tag.func_74775_l("Slot" + i));
                continue;
            }
            if (this.tag.func_74764_b("slot" + i)) {
                this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)this.tag.func_74775_l("slot" + i));
                continue;
            }
            this.inventory[i] = null;
        }
    }

    protected void saveStacks() {
        int i = this.inventory.length;
        while (i-- > 0) {
            if (this.inventory[i] == null) {
                this.tag.func_82580_o("Slot" + i);
                continue;
            }
            this.tag.func_74782_a("Slot" + i, (NBTBase)this.inventory[i].func_77955_b(new NBTTagCompound()));
        }
        this.stack.func_77983_a("Inventory", (NBTBase)this.tag);
    }

    public void func_70296_d() {
        this.saveStacks();
        this.dirty = true;
    }

    public boolean getDirty() {
        boolean r = this.dirty;
        this.dirty = false;
        return r;
    }

    public Item getContainerItem() {
        return this.stack.func_77973_b();
    }

    public ItemStack getContainerStack() {
        this.saveStacks();
        return this.stack;
    }

    public int func_70302_i_() {
        return this.inventoryItem.getSizeInventory(this.stack);
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack s = this.inventory[i];
        if (s == null) {
            return null;
        }
        ItemStack r = s.func_77979_a(j);
        if (s.field_77994_a <= 0) {
            this.inventory[i] = null;
            r.field_77994_a += s.field_77994_a;
        }
        return r;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IInventoryContainerItem) {
            return ((IInventoryContainerItem)stack.func_77973_b()).getSizeInventory(stack) <= 0;
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.stack.func_82833_r();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.stack.func_82833_r());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        this.func_70296_d();
    }
}

