/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.world.IGeneratorParser;
import cofh.lib.world.WorldGenMinablePlate;
import com.typesafe.config.Config;
import java.util.List;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class PlateParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
        int clusterSize = genObject.getInt("radius");
        if (clusterSize <= 0) {
            log.warn("Invalid radius for generator '%s'", new Object[]{name});
            return null;
        }
        WorldGenMinablePlate r = new WorldGenMinablePlate(resList, MathHelper.clamp(clusterSize, 0, 32), matList);
        if (genObject.hasPath("height")) {
            r.setHeight(FeatureParser.parseNumberValue(genObject.root().get((Object)"height"), 0L, 64L));
        }
        if (genObject.hasPath("slim")) {
            r.setSlim(genObject.getBoolean("slim"));
        }
        return r;
    }
}

