/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCore;
import cofh.core.render.IModelRegister;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMulti
extends ItemCore
implements IModelRegister {
    protected TMap<Integer, ItemEntry> itemMap = new THashMap();
    protected ArrayList<Integer> itemList = new ArrayList();

    public ItemMulti() {
        this("cofh");
    }

    public ItemMulti(String modName) {
        super(modName);
    }

    protected void addInformationDelegate(ItemStack stack, EntityPlayer player, List<String> list, boolean check) {
        int i = ItemHelper.getItemDamage(stack);
        if (!this.itemMap.containsKey((Object)i)) {
            return;
        }
        ItemEntry item = (ItemEntry)this.itemMap.get((Object)i);
        list.add(StringHelper.getInfoText("info." + this.modName + "." + this.name + "." + item.name));
    }

    public ItemStack addItem(int number, ItemEntry entry) {
        if (this.itemMap.containsKey((Object)number)) {
            return null;
        }
        this.itemMap.put((Object)number, (Object)entry);
        this.itemList.add(number);
        return new ItemStack((Item)this, 1, number);
    }

    public ItemStack addItem(int number, String name, EnumRarity rarity) {
        return this.addItem(number, new ItemEntry(name, rarity));
    }

    public ItemStack addItem(int number, String name) {
        return this.addItem(number, new ItemEntry(name));
    }

    public ItemStack addOreDictItem(int number, String name, String oreName, EnumRarity rarity) {
        ItemStack stack = this.addItem(number, name, rarity);
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
        return stack;
    }

    public ItemStack addOreDictItem(int number, String name, String oreName) {
        ItemStack stack = this.addItem(number, name);
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
        return stack;
    }

    public ItemStack addOreDictItem(int number, String name, EnumRarity rarity) {
        return this.addOreDictItem(number, name, name, rarity);
    }

    public ItemStack addOreDictItem(int number, String name) {
        return this.addOreDictItem(number, name, name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int metadata : this.itemList) {
            list.add(new ItemStack(item, 1, metadata));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int i = ItemHelper.getItemDamage(stack);
        if (!this.itemMap.containsKey((Object)i)) {
            return EnumRarity.COMMON;
        }
        return ((ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)ItemHelper.getItemDamage((ItemStack)stack)))).rarity;
    }

    public String func_77667_c(ItemStack stack) {
        int i = ItemHelper.getItemDamage(stack);
        if (!this.itemMap.containsKey((Object)i)) {
            return "item.invalid";
        }
        ItemEntry item = (ItemEntry)this.itemMap.get((Object)i);
        return this.func_77658_a() + "." + item.name;
    }

    public Item func_77655_b(String name) {
        GameRegistry.register((IForgeRegistryEntry)this.setRegistryName(name));
        this.name = name;
        name = this.modName + "." + name;
        return super.func_77655_b(name);
    }

    public Item setUnlocalizedName(String name, String registrationName) {
        GameRegistry.register((IForgeRegistryEntry)this.setRegistryName(registrationName));
        this.name = name;
        name = this.modName + "." + name;
        return super.func_77655_b(name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "type=" + ((ItemEntry)entry.getValue()).name));
        }
    }

    public class ItemEntry {
        public String name;
        public EnumRarity rarity;

        ItemEntry(String name, EnumRarity rarity) {
            this.name = name;
            this.rarity = rarity;
        }

        ItemEntry(String name) {
            this(name, EnumRarity.COMMON);
        }
    }
}

