/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.lib.util.helpers.ItemHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorCore
extends ItemArmor {
    protected String repairIngot = "";
    protected String[] textures = new String[2];
    protected boolean showInCreative = true;
    protected Multimap<String, AttributeModifier> field_185051_m = HashMultimap.create();

    public ItemArmorCore(ItemArmor.ArmorMaterial material, EntityEquipmentSlot type) {
        super(material, 0, type);
    }

    public ItemArmorCore putAttribute(String attribute, AttributeModifier modifier) {
        this.field_185051_m.put((Object)attribute, (Object)modifier);
        return this;
    }

    public ItemArmorCore setArmorTextures(String[] textures) {
        this.textures = textures;
        return this;
    }

    public ItemArmorCore setRepairIngot(String repairIngot) {
        this.repairIngot = repairIngot;
        return this;
    }

    public ItemArmorCore setShowInCreative(boolean showInCreative) {
        this.showInCreative = showInCreative;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        if (this.showInCreative) {
            list.add(new ItemStack(item, 1, 0));
        }
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return ItemHelper.isOreNameEqual(stack, this.repairIngot);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (slot == EntityEquipmentSlot.LEGS) {
            return this.textures[1];
        }
        return this.textures[0];
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot == this.field_77881_a) {
            Multimap map = super.getAttributeModifiers(slot, stack);
            map.putAll(this.field_185051_m);
            return map;
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

