/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.core.init.CoreTextures;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.MathHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class TabScrolledText
extends TabBase {
    protected List<String> myText;
    protected int firstLine = 0;
    protected int maxFirstLine = 0;
    protected int numLines = 0;

    public TabScrolledText(GuiBase gui, int side, String infoString) {
        super(gui, side);
        this.maxHeight = 92;
        this.myText = this.getFontRenderer().func_78271_c(infoString, this.maxWidth - 16);
        this.numLines = Math.min(this.myText.size(), (this.maxHeight - 24) / this.getFontRenderer().field_78288_b);
        this.maxFirstLine = this.myText.size() - this.numLines;
    }

    public abstract TextureAtlasSprite getIcon();

    public abstract String getTitle();

    @Override
    protected void drawForeground() {
        this.drawTabIcon(this.getIcon());
        if (!this.isFullyOpened()) {
            return;
        }
        if (this.firstLine > 0) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP, this.posXOffset() + this.maxWidth - 20, this.posY + 16);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP_INACTIVE, this.posXOffset() + this.maxWidth - 20, this.posY + 16);
        }
        if (this.firstLine < this.maxFirstLine) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN, this.posXOffset() + this.maxWidth - 20, this.posY + 76);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN_INACTIVE, this.posXOffset() + this.maxWidth - 20, this.posY + 76);
        }
        this.getFontRenderer().func_175063_a(this.getTitle(), (float)(this.posXOffset() + 18), (float)(this.posY + 6), this.headerColor);
        for (int i = this.firstLine; i < this.firstLine + this.numLines; ++i) {
            this.getFontRenderer().func_78276_b(this.myText.get(i), this.posXOffset() + 2, this.posY + 20 + (i - this.firstLine) * this.getFontRenderer().field_78288_b, this.textColor);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.getTitle());
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) throws IOException {
        int shiftedMouseX = mouseX - this.posX();
        int shiftedMouseY = mouseY - this.posY;
        if (!this.isFullyOpened()) {
            return false;
        }
        if (shiftedMouseX < 108) {
            return super.onMousePressed(mouseX, mouseY, mouseButton);
        }
        this.firstLine = shiftedMouseY < 52 ? MathHelper.clamp(this.firstLine - 1, 0, this.maxFirstLine) : MathHelper.clamp(this.firstLine + 1, 0, this.maxFirstLine);
        return true;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (movement > 0) {
            this.firstLine = MathHelper.clamp(this.firstLine - 1, 0, this.maxFirstLine);
            return true;
        }
        if (movement < 0) {
            this.firstLine = MathHelper.clamp(this.firstLine + 1, 0, this.maxFirstLine);
            return true;
        }
        return false;
    }
}

