/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.block.IFogOverlay;
import cofh.core.render.IModelRegister;
import cofh.core.render.particle.EntityDropParticleFX;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidCore
extends BlockFluidClassic
implements IInitializer,
IFogOverlay,
IModelRegister {
    protected String modName;
    protected String name;
    protected float particleRed = 1.0f;
    protected float particleGreen = 1.0f;
    protected float particleBlue = 1.0f;
    protected boolean shouldDisplaceFluids = false;

    public BlockFluidCore(Fluid fluid, Material material, String modName, String name) {
        super(fluid, material);
        this.name = name;
        this.modName = modName;
        this.func_149663_c(modName + ".fluid." + name);
        this.displacements.put(this, false);
    }

    public BlockFluidCore(Fluid fluid, Material material, String name) {
        this(fluid, material, "cofh", name);
    }

    public BlockFluidCore setParticleColor(int c) {
        return this.setParticleColor((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f);
    }

    public BlockFluidCore setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    public BlockFluidCore setDisplaceFluids(boolean a) {
        this.shouldDisplaceFluids = a;
        return this;
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        double fluidHeight;
        if (this.density < 0) {
            return null;
        }
        if (iblockstate.func_185904_a().func_76224_d() && yToTest >= (fluidHeight = (double)((float)(blockpos.func_177956_o() + 1) - BlockLiquid.func_149801_b((int)((Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b)))))) {
            return true;
        }
        return super.isEntityInsideMaterial(world, blockpos, iblockstate, entity, yToTest, materialIn, testingHead);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        double px = (float)pos.func_177958_n() + rand.nextFloat();
        double py = (double)pos.func_177956_o() - 1.05;
        double pz = (float)pos.func_177952_p() + rand.nextFloat();
        if (this.density < 0) {
            py = (double)pos.func_177956_o() + 2.1;
        }
        if (rand.nextInt(20) == 0 && world.isSideSolid(pos.func_177982_a(0, this.densityDir, 0), this.densityDir == -1 ? EnumFacing.UP : EnumFacing.DOWN) && !world.func_180495_p(pos.func_177982_a(0, 2 * this.densityDir, 0)).func_185904_a().func_76230_c()) {
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue, this.densityDir);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (!this.shouldDisplaceFluids && world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (!this.shouldDisplaceFluids && world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public int getDensity() {
        return this.density;
    }

    public int getDensityDir() {
        return this.densityDir;
    }

    public float getParticleRed() {
        return this.particleRed;
    }

    public float getParticleGreen() {
        return this.particleGreen;
    }

    public float getParticleBlue() {
        return this.particleBlue;
    }

    private boolean isFluid(IBlockState state) {
        return state.func_185904_a().func_76224_d() || state.func_177230_c() instanceof IFluidBlock;
    }

    private float getFluidHeightForRender(IBlockAccess world, BlockPos pos, IBlockState up) {
        IBlockState here = world.func_180495_p(pos);
        if (here.func_177230_c() == this) {
            if (this.isFluid(up)) {
                return 1.0f;
            }
            if (this.func_176201_c(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.func_177230_c() instanceof BlockLiquid) {
            return Math.min(1.0f - BlockLiquid.func_149801_b((int)((Integer)here.func_177229_b((IProperty)BlockLiquid.field_176367_b))), 0.875f);
        }
        return !here.func_185904_a().func_76220_a() && up.func_177230_c() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty((IUnlistedProperty)FLOW_DIRECTION, (Object)Float.valueOf((float)BlockFluidCore.getFlowDirection((IBlockAccess)worldIn, (BlockPos)pos)));
        IBlockState[][] upBlockState = new IBlockState[3][3];
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        upBlockState[1][1] = worldIn.func_180495_p(pos.func_177979_c(this.densityDir));
        height[1][1] = this.getFluidHeightForRender(worldIn, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            int j;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    upBlockState[i][j] = worldIn.func_180495_p(pos.func_177982_a(i - 1, 0, j - 1).func_177979_c(this.densityDir));
                    height[i][j] = this.getFluidHeightForRender(worldIn, pos.func_177982_a(i - 1, 0, j - 1), upBlockState[i][j]);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(new float[]{height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]});
                }
            }
            boolean n = this.isFluid(upBlockState[0][1]);
            boolean s = this.isFluid(upBlockState[2][1]);
            boolean w = this.isFluid(upBlockState[1][0]);
            boolean e = this.isFluid(upBlockState[1][2]);
            boolean nw = this.isFluid(upBlockState[0][0]);
            boolean ne = this.isFluid(upBlockState[0][2]);
            boolean sw = this.isFluid(upBlockState[2][0]);
            boolean se = this.isFluid(upBlockState[2][2]);
            if (nw || n || w) {
                corner[0][0] = 1.0f;
            }
            if (ne || n || e) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e) {
                corner[1][1] = 1.0f;
            }
        }
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[0], (Object)Float.valueOf(corner[0][0]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[1], (Object)Float.valueOf(corner[0][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[2], (Object)Float.valueOf(corner[1][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[3], (Object)Float.valueOf(corner[1][0]));
        return state;
    }

    @Override
    public Vec3d getFog(IBlockState state, Entity renderViewEntity, float fogColorRed, float fogColorGreen, float fogColorBlue) {
        return new Vec3d((double)this.particleRed, (double)this.particleGreen, (double)this.particleBlue);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        StateMapper mapper = new StateMapper(this.modName, "fluid", this.name);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
    }

    @Override
    public boolean preInit() {
        return false;
    }

    @Override
    public boolean initialize() {
        return false;
    }

    @Override
    public boolean postInit() {
        return false;
    }
}

