/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.energy;

import cofh.lib.util.ItemWrapper;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class FurnaceFuelHandler
implements IFuelHandler {
    public static FurnaceFuelHandler instance = new FurnaceFuelHandler();
    private static THashMap<ItemWrapper, Integer> fuels = new THashMap();

    public static void initialize() {
        GameRegistry.registerFuelHandler((IFuelHandler)instance);
    }

    private FurnaceFuelHandler() {
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel == null || !fuels.containsKey((Object)new ItemWrapper(fuel))) {
            return 0;
        }
        return (Integer)fuels.get((Object)new ItemWrapper(fuel));
    }

    public static boolean registerFuel(ItemStack fuel, int burnTime) {
        if (fuel == null || burnTime <= 0 || fuels.containsKey((Object)new ItemWrapper(fuel))) {
            return false;
        }
        fuels.put((Object)new ItemWrapper(fuel), (Object)burnTime);
        return true;
    }

    public static void refresh() {
        THashMap tempMap = new THashMap();
        for (Map.Entry entry : fuels.entrySet()) {
            ItemWrapper tempItem = new ItemWrapper(((ItemWrapper)entry.getKey()).item, ((ItemWrapper)entry.getKey()).metadata);
            tempMap.put((Object)tempItem, entry.getValue());
        }
        fuels.clear();
        fuels = tempMap;
    }
}

