/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.energy;

import cofh.api.energy.EnergyStorage;

public class EnergyStorageCore
extends EnergyStorage {
    public EnergyStorageCore(int capacity) {
        this(capacity, capacity, capacity);
    }

    public EnergyStorageCore(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public EnergyStorageCore(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public int getSpace() {
        return this.energy >= this.capacity ? 0 : this.capacity - this.energy;
    }

    public int receiveEnergyNoLimit(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergyNoLimit(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }
}

