/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.core.world.FeatureParser;
import cofh.core.world.WorldHandler;
import cofh.lib.world.IFeatureGenerator;
import com.google.common.base.Throwables;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class CommandReloadWorldgen
implements ISubCommand {
    public static ISubCommand instance = new CommandReloadWorldgen();

    @Override
    public String getCommandName() {
        return "reloadworldgen";
    }

    @Override
    public int getPermissionLevel() {
        return 3;
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        for (IFeatureGenerator g : FeatureParser.parsedFeatures) {
            WorldHandler.instance.removeFeature(g);
        }
        FeatureParser.parsedFeatures.clear();
        try {
            FeatureParser.parseGenerationFiles();
        }
        catch (Throwable t) {
            Throwables.propagate((Throwable)t);
        }
        CommandHandler.logAdminCommand(sender, this, "chat.cofh.command.reloadworldgen.success", new Object[0]);
    }

    @Override
    public List<String> addTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args) {
        return null;
    }
}

