/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.core.world.TickHandlerWorld;
import cofh.lib.util.ChunkCoord;
import com.google.common.base.Throwables;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CommandPregen
implements ISubCommand {
    public static ISubCommand instance = new CommandPregen();

    @Override
    public String getCommandName() {
        return "pregen";
    }

    @Override
    public int getPermissionLevel() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int zL;
        int xL;
        int xS;
        if (args.length < 4) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.command.syntaxError", new Object[0]));
            throw new WrongUsageException("chat.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
        }
        World world = sender.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        BlockPos center = null;
        int i = 1;
        if ("@".equals(args[i])) {
            center = sender.func_180425_c();
            int n = ++i;
            xS = CommandBase.func_175755_a((String)args[n]);
        } else {
            try {
                xS = CommandBase.func_175755_a((String)args[i++]);
            }
            catch (Throwable t) {
                center = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[i - 1]).func_180425_c();
                xS = CommandBase.func_175755_a((String)args[i++]);
            }
        }
        int n = ++i;
        int zS = CommandBase.func_175755_a((String)args[n]);
        int t = ++i + 1;
        try {
            xL = CommandBase.func_175755_a((String)args[i++]);
            zL = CommandBase.func_175755_a((String)args[i++]);
        }
        catch (Throwable e) {
            if (i > t || center == null) {
                throw Throwables.propagate((Throwable)e);
            }
            --i;
            xL = xS;
            zL = zS;
        }
        if (center != null) {
            xS = center.func_177958_n() / 16 - xS;
            zS = center.func_177952_p() / 16 - zS;
            xL = center.func_177958_n() / 16 + xL;
            zL = center.func_177952_p() / 16 + zL;
        }
        if (xL < xS) {
            t = xS;
            xS = xL;
            xL = t;
        }
        if (zL < zS) {
            t = zS;
            zS = zL;
            zL = t;
        }
        TIntObjectHashMap<ArrayDeque<ChunkCoord>> tIntObjectHashMap = TickHandlerWorld.chunksToPreGen;
        synchronized (tIntObjectHashMap) {
            ArrayDeque<ChunkCoord> chunks = (ArrayDeque<ChunkCoord>)TickHandlerWorld.chunksToPreGen.get(world.field_73011_w.getDimension());
            if (chunks == null) {
                chunks = new ArrayDeque<ChunkCoord>();
            }
            for (int x = xS; x <= xL; ++x) {
                for (int z = zS; z <= zL; ++z) {
                    chunks.addLast(new ChunkCoord(x, z));
                }
            }
            TickHandlerWorld.chunksToPreGen.put(world.field_73011_w.getDimension(), chunks);
            CommandHandler.logAdminCommand(sender, this, "chat.cofh.command.pregen.start", (xL - xS) * (zL - zS), xS, zS, xL, zL);
        }
    }

    @Override
    public List<String> addTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return null;
    }
}

