/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm.repack.codechicken.lib.asm;

import cofh.asm.repack.codechicken.lib.asm.ASMBlock;
import cofh.asm.repack.codechicken.lib.asm.ASMHelper;
import cofh.asm.repack.codechicken.lib.asm.InsnComparator;
import cofh.asm.repack.codechicken.lib.asm.InsnListSection;
import cofh.asm.repack.codechicken.lib.asm.LocalVariablesSorterVisitor;
import cofh.asm.repack.codechicken.lib.asm.ObfMapping;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class ModularASMTransformer {
    public HashMap<String, ClassNodeTransformerList> transformers = new HashMap();

    public void add(@Nonnull ClassNodeTransformer t) {
        ClassNodeTransformerList list = this.transformers.get(t.className());
        if (list == null) {
            list = new ClassNodeTransformerList();
            this.transformers.put(t.className(), list);
        }
        list.add(t);
    }

    public byte[] transform(@Nonnull String name, @Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNodeTransformerList list = this.transformers.get(name);
        return list == null ? bytes : list.transform(bytes);
    }

    public static class FieldWriter
    extends ClassNodeTransformer {
        public final ObfMapping field;
        public final int access;
        public final Object value;

        public FieldWriter(@Nonnull int access, @Nonnull ObfMapping field, @Nullable Object value) {
            this.field = field.toRuntime();
            this.access = access;
            this.value = value;
        }

        public FieldWriter(@Nonnull int access, @Nonnull ObfMapping field) {
            this(access, field, null);
        }

        @Override
        public String className() {
            return this.field.javaClass();
        }

        @Override
        public void transform(ClassNode cnode) {
            this.field.visitField((ClassVisitor)cnode, this.access, this.value);
        }
    }

    public static class MethodReplacer
    extends MethodTransformer {
        public ASMBlock needle;
        public ASMBlock replacement;

        public MethodReplacer(@Nonnull ObfMapping method, @Nonnull ASMBlock needle, @Nonnull ASMBlock replacement) {
            super(method);
            this.needle = needle;
            this.replacement = replacement;
        }

        public MethodReplacer(@Nonnull ObfMapping method, @Nonnull InsnList needle, @Nonnull InsnList replacement) {
            this(method, new ASMBlock(needle), new ASMBlock(replacement));
        }

        @Override
        public void addMethodsToSort(Set<ObfMapping> set) {
            set.add(this.method);
        }

        @Override
        public void transform(MethodNode mv) {
            for (InsnListSection key : InsnComparator.findN(mv.instructions, this.needle.list)) {
                ASMHelper.logger.debug("Replacing method " + this.method + " @ " + key.start + " - " + key.end);
                ASMBlock replaceBlock = this.replacement.copy().pullLabels(this.needle.applyLabels(key));
                key.insert(replaceBlock.list.list);
            }
        }
    }

    public static class MethodInjector
    extends MethodTransformer {
        @Nullable
        public ASMBlock needle;
        @Nonnull
        public ASMBlock injection;
        public boolean before;

        public MethodInjector(@Nonnull ObfMapping method, @Nullable ASMBlock needle, @Nonnull ASMBlock injection, @Nonnull boolean before) {
            super(method);
            this.needle = needle;
            this.injection = injection;
            this.before = before;
        }

        public MethodInjector(@Nonnull ObfMapping method, @Nonnull ASMBlock injection, @Nonnull boolean before) {
            this(method, null, injection, before);
        }

        public MethodInjector(@Nonnull ObfMapping method, @Nonnull InsnList needle, @Nonnull InsnList injection, @Nonnull boolean before) {
            this(method, new ASMBlock(needle), new ASMBlock(injection), before);
        }

        public MethodInjector(@Nonnull ObfMapping method, @Nonnull InsnList injection, @Nonnull boolean before) {
            this(method, null, new ASMBlock(injection), before);
        }

        @Override
        public void addMethodsToSort(Set<ObfMapping> set) {
            set.add(this.method);
        }

        @Override
        public void transform(MethodNode mv) {
            if (this.needle == null) {
                ASMHelper.logger.debug("Injecting " + (this.before ? "before" : "after") + " method " + this.method);
                if (this.before) {
                    mv.instructions.insert(this.injection.rawListCopy());
                } else {
                    mv.instructions.add(this.injection.rawListCopy());
                }
            } else {
                for (InsnListSection key : InsnComparator.findN(mv.instructions, this.needle.list)) {
                    ASMHelper.logger.debug("Injecting " + (this.before ? "before" : "after") + " method " + this.method + " @ " + key.start + " - " + key.end);
                    ASMBlock injectBlock = this.injection.copy().mergeLabels(this.needle.applyLabels(key));
                    if (this.before) {
                        key.insertBefore(injectBlock.list.list);
                        continue;
                    }
                    key.insert(injectBlock.list.list);
                }
            }
        }
    }

    public static class MethodWriter
    extends ClassNodeTransformer {
        public final int access;
        public final ObfMapping method;
        public final String[] exceptions;
        public InsnList list;

        public MethodWriter(int access, @Nonnull ObfMapping method) {
            this(access, method, null, (InsnList)null);
        }

        public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable InsnList list) {
            this(access, method, null, list);
        }

        public MethodWriter(int access, @Nonnull ObfMapping method, @Nonnull ASMBlock block) {
            this(access, method, null, block);
        }

        public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable String[] exceptions) {
            this(access, method, exceptions, (InsnList)null);
        }

        public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable String[] exceptions, @Nullable InsnList list) {
            this.access = access;
            this.method = method.toRuntime();
            this.exceptions = exceptions;
            this.list = list;
        }

        public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable String[] exceptions, @Nonnull ASMBlock block) {
            this(access, method, exceptions, block.rawListCopy());
        }

        @Override
        public String className() {
            return this.method.javaClass();
        }

        @Override
        public void transform(ClassNode cnode) {
            MethodNode mv = ASMHelper.findMethod(this.method, cnode);
            if (mv == null) {
                mv = (MethodNode)this.method.visitMethod((ClassVisitor)cnode, this.access, this.exceptions);
            } else {
                mv.access = this.access;
                mv.instructions.clear();
                if (mv.localVariables != null) {
                    mv.localVariables.clear();
                }
                if (mv.tryCatchBlocks != null) {
                    mv.tryCatchBlocks.clear();
                }
            }
            this.write(mv);
        }

        public void write(MethodNode mv) {
            ASMHelper.logger.debug("Writing method " + this.method);
            this.list.accept((MethodVisitor)mv);
        }
    }

    public static abstract class MethodTransformer
    extends ClassNodeTransformer {
        public final ObfMapping method;

        public MethodTransformer(ObfMapping method) {
            this.method = method.toRuntime();
        }

        @Override
        public String className() {
            return this.method.javaClass();
        }

        @Override
        public void transform(ClassNode cnode) {
            MethodNode mv = ASMHelper.findMethod(this.method, cnode);
            if (mv == null) {
                throw new RuntimeException("Method not found: " + this.method);
            }
            try {
                this.transform(mv);
            }
            catch (Exception e) {
                throw new RuntimeException("Error transforming method: " + this.method, e);
            }
        }

        public abstract void transform(MethodNode var1);
    }

    public static abstract class ClassNodeTransformer {
        public int writeFlags;

        public ClassNodeTransformer(int writeFlags) {
            this.writeFlags = writeFlags;
        }

        public ClassNodeTransformer() {
            this(3);
        }

        public abstract String className();

        public abstract void transform(ClassNode var1);

        public void addMethodsToSort(Set<ObfMapping> set) {
        }
    }

    public static class ClassNodeTransformerList {
        List<ClassNodeTransformer> transformers = new LinkedList<ClassNodeTransformer>();
        HashSet<ObfMapping> methodsToSort = new HashSet();

        public void add(ClassNodeTransformer t) {
            this.transformers.add(t);
            t.addMethodsToSort(this.methodsToSort);
        }

        public byte[] transform(byte[] bytes) {
            ClassNode cnode = new ClassNode();
            ClassReader reader = new ClassReader(bytes);
            Object cv = cnode;
            if (!this.methodsToSort.isEmpty()) {
                cv = new LocalVariablesSorterVisitor(this.methodsToSort, (ClassVisitor)cv);
            }
            reader.accept((ClassVisitor)cv, 8);
            try {
                int writeFlags = 0;
                for (ClassNodeTransformer t : this.transformers) {
                    t.transform(cnode);
                    writeFlags |= t.writeFlags;
                }
                bytes = ASMHelper.createBytes(cnode, writeFlags);
                if (Boolean.parseBoolean(System.getProperty("cofh.asm.ccl.dump_raw", "false"))) {
                    File file = new File("asm/ccl_modular/" + cnode.name.replace('/', '#') + ".class");
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(bytes);
                    fos.flush();
                    fos.close();
                } else if (Boolean.parseBoolean(System.getProperty("cofh.asm.ccl.dump", "true"))) {
                    ASMHelper.dump(bytes, new File("asm/ccl_modular/" + cnode.name.replace('/', '#') + ".txt"), false, false);
                }
                return bytes;
            }
            catch (Exception e) {
                ASMHelper.dump(bytes, new File("asm/ccl_modular/" + cnode.name.replace('/', '#') + ".txt"), false, false);
                throw new RuntimeException(e);
            }
        }
    }
}

