/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.core.command.CommandHandler;
import cofh.core.energy.FurnaceFuelHandler;
import cofh.core.gui.GuiHandler;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.key.KeyHandlerCore;
import cofh.core.key.PacketKey;
import cofh.core.network.PacketCore;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketIndexedChat;
import cofh.core.network.PacketSocial;
import cofh.core.network.PacketTile;
import cofh.core.network.PacketTileInfo;
import cofh.core.proxy.Proxy;
import cofh.core.util.ConfigHandler;
import cofh.core.util.RegistrySocial;
import cofh.core.util.crafting.RecipeSecure;
import cofh.core.util.crafting.RecipeShapelessOreFluid;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.core.util.crafting.RecipeUpgradeOverride;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.core.world.FeatureParser;
import cofh.core.world.WorldHandler;
import cofh.lib.util.helpers.ItemHelper;
import java.io.File;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cofhcore", name="CoFH Core", version="4.1.11", dependencies="required-after:Forge@[12.18.3.2185,12.19.0.0);", updateJSON="https://raw.github.com/cofh/version/master/cofhcore_update.json", acceptedMinecraftVersions="[1.10.2]")
public class CoFHCore {
    public static final String MOD_ID = "cofhcore";
    public static final String MOD_NAME = "CoFH Core";
    public static final String VERSION = "4.1.11";
    public static final String VERSION_MAX = "4.2.0";
    public static final String VERSION_GROUP = "required-after:cofhcore@[4.1.11,4.2.0);";
    public static final String UPDATE_URL = "https://raw.github.com/cofh/version/master/cofhcore_update.json";
    public static final String DEPENDENCIES = "required-after:Forge@[12.18.3.2185,12.19.0.0);";
    public static final String MOD_GUI_FACTORY = "cofh.core.gui.GuiConfigCoreFactory";
    @Mod.Instance(value="cofhcore")
    public static CoFHCore instance;
    @SidedProxy(clientSide="cofh.core.proxy.ProxyClient", serverSide="cofh.core.proxy.Proxy")
    public static Proxy proxy;
    public static final Logger LOG;
    public static final ConfigHandler CONFIG_CORE;
    public static final ConfigHandler CONFIG_LOOT;
    public static final ConfigHandler CONFIG_CLIENT;
    public static final GuiHandler GUI_HANDLER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CoreProps.configDir = event.getModConfigurationDirectory();
        CONFIG_CORE.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/core/common.cfg"), true));
        CONFIG_CLIENT.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/core/client.cfg"), true));
        CoreProps.preInit();
        CoreEnchantments.preInit();
        PacketHandler.preInit();
        this.addOreDictionaryEntries();
        this.registerHandlers();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        this.addCraftingRecipes();
        proxy.initialize(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        OreDictionaryArbiter.initialize();
        PacketHandler.postInit();
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        CoreProps.loadComplete();
        CONFIG_CORE.cleanUp(false, true);
        CONFIG_CLIENT.cleanUp(false, true);
        try {
            FeatureParser.parseGenerationFiles();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        LOG.info("CoFH Core: Load Complete.");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent event) {
        CoreProps.server = event.getServer();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        CommandHandler.initCommands(event);
    }

    @Mod.EventHandler
    public void handleIdMappingEvent(FMLModIdMappingEvent event) {
        OreDictionaryArbiter.refresh();
        FurnaceFuelHandler.refresh();
    }

    private void registerHandlers() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)GUI_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)KeyHandlerCore.instance);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)proxy);
        FurnaceFuelHandler.initialize();
        FeatureParser.initialize();
        WorldHandler.initialize();
        RegistrySocial.initialize();
        PacketCore.initialize();
        PacketIndexedChat.initialize();
        PacketSocial.initialize();
        PacketKey.initialize();
        PacketTileInfo.initialize();
        PacketTile.initialize();
        RecipeSorter.register((String)"cofhcore:shapelessorefluid", RecipeShapelessOreFluid.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"cofhcore:secure", RecipeSecure.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofhcore:upgrade");
        RecipeSorter.register((String)"cofhcore:upgrade", RecipeUpgrade.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
        RecipeSorter.register((String)"cofhcore:upgradeoverride", RecipeUpgradeOverride.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
    }

    private void addCraftingRecipes() {
        if (CoreProps.enableHorseArmorCrafting) {
            ItemHelper.addRecipe(ItemHelper.ShapedRecipe(Items.field_151138_bX, "  H", "ICI", "III", Character.valueOf('C'), "blockWool", Character.valueOf('H'), Items.field_151028_Y, Character.valueOf('I'), "ingotIron"));
            ItemHelper.addRecipe(ItemHelper.ShapedRecipe(Items.field_151136_bY, "  H", "ICI", "III", Character.valueOf('C'), "blockWool", Character.valueOf('H'), Items.field_151169_ag, Character.valueOf('I'), "ingotGold"));
            ItemHelper.addRecipe(ItemHelper.ShapedRecipe(Items.field_151125_bZ, "  H", "ICI", "III", Character.valueOf('C'), "blockWool", Character.valueOf('H'), Items.field_151161_ac, Character.valueOf('I'), "gemDiamond"));
        }
        if (CoreProps.enableSaddleCrafting) {
            ItemHelper.addRecipe(ItemHelper.ShapedRecipe(Items.field_151141_av, "LLL", "LIL", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), Items.field_151116_aA));
        }
    }

    private void addOreDictionaryEntries() {
        OreDictionary.registerOre((String)"blockWool", (ItemStack)new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"coal", (ItemStack)new ItemStack(Items.field_151044_h, 1, 0));
        OreDictionary.registerOre((String)"charcoal", (ItemStack)new ItemStack(Items.field_151044_h, 1, 1));
    }

    static {
        LOG = LogManager.getLogger((String)MOD_ID);
        CONFIG_CORE = new ConfigHandler(VERSION);
        CONFIG_LOOT = new ConfigHandler(VERSION);
        CONFIG_CLIENT = new ConfigHandler(VERSION);
        GUI_HANDLER = new GuiHandler();
    }
}

