/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.RecipeObjectType;

public class DefaultSonarRecipe
implements ISonarRecipe {
    public ArrayList<ISonarRecipeObject> recipeInputs;
    public ArrayList<ISonarRecipeObject> recipeOutputs;
    public boolean shapeless;

    public DefaultSonarRecipe(ArrayList<ISonarRecipeObject> inputs, ArrayList<ISonarRecipeObject> outputs, boolean shapeless) {
        this.recipeInputs = inputs;
        this.recipeOutputs = outputs;
        this.shapeless = shapeless;
    }

    @Override
    public List<ISonarRecipeObject> inputs() {
        return this.recipeInputs;
    }

    @Override
    public List<ISonarRecipeObject> outputs() {
        return this.recipeOutputs;
    }

    @Override
    public boolean matchingInputs(Object[] inputs) {
        return RecipeHelperV2.matchingIngredients(RecipeObjectType.INPUT, this.recipeInputs, this.shapeless, inputs);
    }

    @Override
    public boolean matchingOutputs(Object[] outputs) {
        return RecipeHelperV2.matchingIngredients(RecipeObjectType.OUTPUT, this.recipeOutputs, this.shapeless, outputs);
    }

    @Override
    public boolean canUseRecipe(EntityPlayer player) {
        return true;
    }

    public static class Value
    extends DefaultSonarRecipe {
        public int value;

        public Value(ArrayList<ISonarRecipeObject> inputs, ArrayList<ISonarRecipeObject> outputs, boolean shapeless, int value) {
            super(inputs, outputs, shapeless);
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

