/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import sonar.core.api.energy.ISonarEnergyStorage;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
public class SyncEnergyStorage
extends DirtyPart
implements ISonarEnergyStorage,
IEnergyStorage,
cofh.api.energy.IEnergyStorage,
ISyncPart,
ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
INBTSerializable<NBTTagCompound> {
    private long energy;
    private long capacity;
    private long maxReceive;
    private long maxExtract;
    private String tagName = "energyStorage";

    public SyncEnergyStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public SyncEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public SyncEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public SyncEnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > (long)capacity) {
            this.energy = capacity;
        }
        this.markChanged();
        return this;
    }

    public SyncEnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public SyncEnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        this.markChanged();
        return this;
    }

    public SyncEnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        this.markChanged();
        return this;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
        this.markChanged();
    }

    public void modifyEnergyStored(int energy) {
        this.energy += (long)energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
        this.markChanged();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        buf.writeLong(this.energy);
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.energy = buf.readLong();
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    public SyncEnergyStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74763_f("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        nbt.func_74772_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public final NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound energyTag = new NBTTagCompound();
        this.writeToNBT(energyTag);
        nbt.func_74782_a(this.getTagName(), (NBTBase)energyTag);
        return nbt;
    }

    @Override
    public final void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.readFromNBT(nbt.func_74775_l(this.getTagName()));
        }
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    public SyncEnergyStorage setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE);
    }

    @Override
    public long addEnergy(long maxReceive, ActionType action) {
        long add = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!action.shouldSimulate()) {
            this.energy += add;
            this.markChanged();
        }
        return add;
    }

    @Override
    public long removeEnergy(long maxExtract, ActionType action) {
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!action.shouldSimulate()) {
            this.energy -= energyExtracted;
            this.markChanged();
        }
        return energyExtracted;
    }

    @Override
    public long getEnergyLevel() {
        return this.energy;
    }

    @Override
    public long getFullCapacity() {
        return this.capacity;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.addEnergy(maxReceive, ActionType.getTypeForAction(simulate));
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.removeEnergy(maxExtract, ActionType.getTypeForAction(simulate));
    }

    @Override
    public int getEnergyStored() {
        return (int)Math.min(this.getEnergyLevel(), Integer.MAX_VALUE);
    }

    @Override
    public int getMaxEnergyStored() {
        return (int)Math.min(this.getFullCapacity(), Integer.MAX_VALUE);
    }

    public long getStoredPower() {
        return this.getEnergyStored();
    }

    public long getCapacity() {
        return this.getMaxEnergyStored();
    }

    public long takePower(long power, boolean simulated) {
        return this.removeEnergy(Math.min(Integer.MAX_VALUE, power), ActionType.getTypeForAction(simulated));
    }

    public long givePower(long power, boolean simulated) {
        return this.addEnergy(power, ActionType.getTypeForAction(simulated));
    }

    public NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readData(nbt, NBTHelper.SyncType.SAVE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

