/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;

public class PacketRequestMultipartSync
extends PacketCoords<PacketRequestMultipartSync> {
    public UUID uuid;

    public PacketRequestMultipartSync() {
    }

    public PacketRequestMultipartSync(BlockPos pos, UUID uuid) {
        super(pos);
        this.uuid = uuid;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        long msb = buf.readLong();
        long lsb = buf.readLong();
        this.uuid = new UUID(msb, lsb);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketRequestMultipartSync> {
        @Override
        public IMessage processMessage(final EntityPlayer player, MessageContext ctx, final PacketRequestMultipartSync message, final TileEntity tile) {
            if (!tile.func_145831_w().field_72995_K) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        IMultipart part;
                        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)tile.func_145831_w(), (BlockPos)tile.func_174877_v());
                        if (container != null && (part = container.getPartFromID(message.uuid)) != null && part instanceof SonarMultipart) {
                            SonarMultipart multipart = (SonarMultipart)part;
                            multipart.forceNextSync();
                            multipart.onSyncPacketRequested(player);
                            SonarMultipartHelper.sendMultipartSyncToPlayer(multipart, (EntityPlayerMP)player);
                            multipart.sendUpdatePacket(true);
                        }
                    }
                });
                return null;
            }
            return null;
        }
    }
}

