/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.helpers.ListHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.utils.Pair;

public class ListenerList<L extends ISonarListener>
extends ArrayList<ListenerTally<L>> {
    public final int maxTypes;
    public boolean isValid = false;
    public boolean hasListeners = false;
    public ArrayList<ISonarListenable<L>> subLists = Lists.newArrayList();
    public ArrayList<ISonarListenable<L>> masterLists = Lists.newArrayList();
    public boolean[] hasTypes;

    public ListenerList(int maxTypes) {
        this.maxTypes = maxTypes;
        this.isValid = true;
        this.hasTypes = new boolean[maxTypes];
    }

    public void updateState() {
        boolean[] states = new boolean[this.maxTypes];
        block0: for (ListenerList<L> list : this.getValidLists(false)) {
            for (ListenerTally listenerTally : list) {
                boolean hasAll = true;
                for (int i = 0; i < states.length; ++i) {
                    if (states[i]) continue;
                    if (listenerTally.getTally(i) > 0) {
                        states[i] = true;
                        continue;
                    }
                    hasAll = false;
                }
                if (!hasAll) continue;
                break block0;
            }
        }
        this.hasTypes = states;
        this.hasListeners = this.checkForListeners();
        this.masterLists.forEach((Consumer<ISonarListenable<L>>)((Consumer<ISonarListenable>)l -> l.getListenerList().updateState()));
    }

    public boolean hasListeners(int type) {
        return this.hasTypes[type];
    }

    public boolean hasListeners() {
        return this.hasListeners;
    }

    public boolean hasListeners(List<Integer> types) {
        for (int i : types) {
            if (!this.hasTypes[i]) continue;
            return true;
        }
        return false;
    }

    public boolean hasListeners(int ... types) {
        for (int i : types) {
            if (!this.hasTypes[i]) continue;
            return true;
        }
        return false;
    }

    private boolean checkForListeners() {
        for (boolean bool : this.hasTypes) {
            if (!bool) continue;
            return true;
        }
        return false;
    }

    public void addSubListenable(ISonarListenable<L> sub) {
        if (!this.subLists.contains(sub) && sub.isValid()) {
            this.subLists.add(sub);
            this.onSubListenableAdded(sub);
            this.updateState();
        }
    }

    public void addMasterListenable(ISonarListenable<L> master) {
        if (!this.masterLists.contains(master) && master.isValid()) {
            this.masterLists.add(master);
        }
    }

    public void removeSubListenable(ISonarListenable<L> sub) {
        if (this.subLists.remove(sub)) {
            this.onSubListenableRemoved(sub);
            this.updateState();
        }
    }

    public void removeMasterListenable(ISonarListenable<L> master) {
        this.subLists.remove(master);
    }

    public void clearSubLists(boolean notify) {
        if (notify) {
            for (ListenerTally tally : this) {
                this.onListenerRemoved(tally);
            }
            this.clearSubLists(false);
        } else {
            this.subLists.clear();
            this.masterLists.clear();
            this.updateState();
        }
    }

    public void validateList() {
        this.isValid = true;
    }

    public void invalidateList() {
        this.clearSubLists(true);
        this.clear();
        this.subLists.clear();
        this.masterLists.clear();
        this.isValid = false;
        this.hasTypes = new boolean[this.maxTypes];
    }

    private List<ListenerList<L>> getValidLists(boolean local) {
        ArrayList<ListenerList<L>> getValidLists = new ArrayList<ListenerList<L>>();
        getValidLists.add(this);
        if (!local) {
            for (ISonarListenable listenable : (List)this.subLists.clone()) {
                if (listenable.isValid()) {
                    getValidLists.add(listenable.getListenerList());
                    continue;
                }
                this.subLists.remove(listenable);
            }
        }
        return getValidLists;
    }

    public void addListener(EntityPlayer listener, Enum ... enums) {
        this.addListener(this.findListener(listener), ListHelper.getOrdinals(enums));
    }

    public void addListener(EntityPlayer listener, int ... types) {
        this.addListener(this.findListener(listener), types);
    }

    public void addListener(L listener, Enum ... enums) {
        this.addListener(listener, ListHelper.getOrdinals(enums));
    }

    public void addListener(L listener, int ... types) {
        if (listener.isValid()) {
            Pair<ListenerTally<L>, Boolean> tally = this.getTally(listener, true);
            if (tally.a != null) {
                int[] nArray = types;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int t;
                    int n2 = t = nArray[i];
                    ((ListenerTally)tally.a).tallies[n2] = ((ListenerTally)tally.a).tallies[n2] + 1;
                }
                if (((Boolean)tally.b).booleanValue()) {
                    this.onListenerAdded((ListenerTally)tally.a);
                }
                this.updateState();
            }
        }
    }

    public void removeListener(EntityPlayer listener, boolean local, Enum ... enums) {
        this.removeListener(this.findListener(listener), local, ListHelper.getOrdinals(enums));
    }

    public void removeListener(EntityPlayer listener, boolean local, int ... types) {
        this.removeListener(this.findListener(listener), local, types);
    }

    public void removeListener(ListenerTally<L> listener, boolean local, Enum ... enums) {
        this.removeListener(listener.listener, local, ListHelper.getOrdinals(enums));
    }

    public void removeListener(L listener, boolean local, Enum ... enums) {
        this.removeListener(listener, local, ListHelper.getOrdinals(enums));
    }

    public void removeListener(L listener, boolean local, int ... types) {
        List<Integer> valid = this.getValidTypes(types);
        for (ListenerList<L> list : this.getValidLists(local)) {
            Pair<ListenerTally<L>, Boolean> tally = super.getTally(listener, false);
            if (tally.a == null) continue;
            Iterator iterator = Lists.newArrayList(valid).iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                if (((ListenerTally)tally.a).tallies[t] <= 0) continue;
                int n = t;
                ((ListenerTally)tally.a).tallies[n] = ((ListenerTally)tally.a).tallies[n] - 1;
                valid.remove((Object)t);
            }
            if (!this.wasRemoved((ListenerTally)tally.a)) continue;
            list.onListenerRemoved((ListenerTally)tally.a);
            list.updateState();
        }
    }

    public void clearListener(L listener) {
        Pair<ListenerTally<L>, Boolean> tally = this.getTally(listener, false);
        if (tally.a != null && this.remove(tally.a)) {
            this.onListenerRemoved((ListenerTally)tally.a);
            this.updateState();
        }
    }

    public PlayerListener findListener(EntityPlayer player) {
        for (ListenerList<L> list : this.getValidLists(false)) {
            for (ListenerTally listenerTally : list) {
                if (!(listenerTally.listener instanceof PlayerListener) || !((PlayerListener)listenerTally.listener).player.func_70028_i((Entity)player)) continue;
                return (PlayerListener)listenerTally.listener;
            }
        }
        return new PlayerListener(player);
    }

    private Pair<ListenerTally<L>, Boolean> getTally(L listener, boolean create) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ListenerTally tally = (ListenerTally)i.next();
            if (!tally.isValid()) {
                i.remove();
                continue;
            }
            if (listener.hashCode() != tally.listener.hashCode() && !listener.equals(tally.listener)) continue;
            return new Pair<ListenerTally<L>, Boolean>(tally, false);
        }
        if (create) {
            ListenerTally<L> created = new ListenerTally<L>(this, listener, this.maxTypes);
            this.add(created);
            return new Pair<ListenerTally<L>, Boolean>(created, true);
        }
        return new Pair<Object, Boolean>(null, false);
    }

    public List<ListenerTally<L>> getTallies(Enum ... enums) {
        return this.getTallies(ListHelper.getOrdinals(enums));
    }

    public List<ListenerTally<L>> getTallies(int ... types) {
        List<Integer> valid = this.getValidTypes(types);
        ArrayList tallies = Lists.newArrayList();
        if (valid.isEmpty() || !this.hasListeners(valid)) {
            return tallies;
        }
        this.getValidLists(false).forEach((? super T list) -> list.forEach((? super E tally) -> {
            if (!tallies.contains(tally)) {
                Iterator iterator = valid.iterator();
                while (iterator.hasNext()) {
                    int type = (Integer)iterator.next();
                    if (tally.getTally(type) <= 0) continue;
                    tallies.add(tally);
                }
            }
        }));
        return tallies;
    }

    public List<L> getListeners(Enum ... enums) {
        return this.getListeners(ListHelper.getOrdinals(enums));
    }

    public List<L> getListeners(int ... types) {
        List<Integer> valid = this.getValidTypes(types);
        ArrayList listeners = Lists.newArrayList();
        if (valid.isEmpty() || !this.hasListeners(valid)) {
            return listeners;
        }
        this.getValidLists(false).forEach((? super T list) -> list.forEach((? super E tally) -> {
            if (!listeners.contains(tally.listener)) {
                Iterator iterator = valid.iterator();
                while (iterator.hasNext()) {
                    int type = (Integer)iterator.next();
                    if (tally.getTally(type) <= 0) continue;
                    listeners.add(tally.listener);
                }
            }
        }));
        return listeners;
    }

    private List<Integer> getValidTypes(int[] types) {
        ArrayList valid = Lists.newArrayList();
        for (int t : types) {
            if (!this.hasListeners(t)) continue;
            valid.add(t);
        }
        return valid;
    }

    private boolean wasRemoved(ListenerTally<L> tally) {
        if (!tally.isValid()) {
            return this.remove(tally);
        }
        return false;
    }

    public void onListenerAdded(ListenerTally<L> tally) {
    }

    public void onListenerRemoved(ListenerTally<L> tally) {
    }

    public void onSubListenableAdded(ISonarListenable<L> tally) {
    }

    public void onSubListenableRemoved(ISonarListenable<L> tally) {
    }
}

