/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.listener;

import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.core.listener.ListenerList;
import sonar.core.listener.ListenerTally;

public class ListenableList<L extends ISonarListener>
extends ListenerList<L> {
    ISonarListenable<L> owner;

    public ListenableList(ISonarListenable<L> listen, int maxTypes) {
        super(maxTypes);
        this.owner = listen;
    }

    @Override
    public void onListenerAdded(ListenerTally<L> tally) {
        super.onListenerAdded(tally);
        this.owner.onListenerAdded(tally);
    }

    @Override
    public void onListenerRemoved(ListenerTally<L> tally) {
        super.onListenerRemoved(tally);
        this.owner.onListenerRemoved(tally);
    }

    @Override
    public void onSubListenableAdded(ISonarListenable<L> listen) {
        super.onSubListenableAdded(listen);
        listen.getListenerList().addMasterListenable(this.owner);
        this.owner.onSubListenableAdded(listen);
    }

    @Override
    public void onSubListenableRemoved(ISonarListenable<L> listen) {
        super.onSubListenableRemoved(listen);
        listen.getListenerList().removeMasterListenable(this.owner);
        this.owner.onSubListenableRemoved(listen);
    }

    @Override
    public void invalidateList() {
        this.masterLists.forEach((? super E list) -> list.getListenerList().removeSubListenable(this.owner));
        super.invalidateList();
    }
}

