/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.integration.SonarLoader;

public class ItemStackHelper {
    public static ItemStack EMPTY = null;

    public static boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return ItemStackHelper.equalStacksRegular(stack1, stack2) && !ItemStackHelper.isCircuit(stack1.func_77973_b()) && stack1.field_77994_a < stack1.func_77976_d();
    }

    public static boolean equalStacksRegular(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack restoreItemStack(ItemStack stack, int size) {
        ItemStack result = stack.func_77946_l();
        if (result.field_77994_a <= 0) {
            result.field_77994_a = size;
        }
        return result;
    }

    public static ItemStack grow(ItemStack stack, int stackSize) {
        if (stack != EMPTY) {
            stack.field_77994_a += stackSize;
        }
        return stack;
    }

    public static ItemStack shrink(ItemStack stack, int stackSize) {
        if (stack != EMPTY) {
            stack.field_77994_a -= stackSize;
        }
        if (stack.field_77994_a <= 0) {
            stack = EMPTY;
        }
        return stack;
    }

    public static boolean isCircuit(Item item) {
        if (SonarLoader.calculatorLoaded()) {
            if (item == GameRegistry.findItem((String)"calculator", (String)"CircuitBoard")) {
                return true;
            }
            if (item == GameRegistry.findItem((String)"calculator", (String)"CircuitDamaged")) {
                return true;
            }
            if (item == GameRegistry.findItem((String)"calculator", (String)"CircuitDirty")) {
                return true;
            }
        }
        return false;
    }

    public static ItemStack createStack(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack stack = ((ItemStack)obj).func_77946_l();
            if (stack.field_77994_a == 0) {
                stack.field_77994_a = 1;
            }
            return stack;
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, 1);
        }
        if (!(obj instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", obj));
        }
        return new ItemStack((Block)obj, 1);
    }

    public static boolean matchingModid(ItemStack target, ItemStack stack) {
        String targetID = target.func_77973_b().getRegistryName().func_110624_b();
        String stackID = stack.func_77973_b().getRegistryName().func_110624_b();
        if (targetID != null && stackID != null && !targetID.isEmpty() && !stackID.isEmpty()) {
            return targetID.equals(stackID);
        }
        return false;
    }

    public static boolean matchingOreDictID(ItemStack target, ItemStack stack) {
        int[] stackIDs = OreDictionary.getOreIDs((ItemStack)stack);
        int[] filterIDs = OreDictionary.getOreIDs((ItemStack)target);
        for (int sID : stackIDs) {
            for (int fID : filterIDs) {
                if (sID != fID) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack reduceStackSize(ItemStack stack, int i) {
        stack.field_77994_a -= i;
        if (stack.field_77994_a <= 0) {
            stack = null;
        }
        return stack;
    }
}

