/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import sonar.core.SonarCore;
import sonar.core.api.asm.EnergyContainerHandler;
import sonar.core.api.asm.EnergyHandler;
import sonar.core.api.asm.FluidHandler;
import sonar.core.api.asm.InventoryHandler;
import sonar.core.api.energy.ISonarEnergyContainerHandler;
import sonar.core.api.energy.ISonarEnergyHandler;
import sonar.core.api.fluids.ISonarFluidHandler;
import sonar.core.api.inventories.ISonarInventoryHandler;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.Pair;
import sonar.core.utils.SortingDirection;

public class ASMLoader {
    public static Comparator<ASMDataTable.ASMData> SORT_PRIORITY = new Comparator<ASMDataTable.ASMData>(){

        @Override
        public int compare(ASMDataTable.ASMData str1, ASMDataTable.ASMData str2) {
            return SonarHelper.compareWithDirection(((Integer)str1.getAnnotationInfo().get("priority")).intValue(), ((Integer)str2.getAnnotationInfo().get("priority")).intValue(), SortingDirection.UP);
        }
    };

    public static void load(@Nonnull ASMDataTable asmDataTable) {
        SonarCore.inventoryHandlers = ASMLoader.getInventoryHandlers(asmDataTable);
        SonarCore.energyHandlers = ASMLoader.getEnergyHandlers(asmDataTable);
        SonarCore.fluidHandlers = ASMLoader.getFluidHandlers(asmDataTable);
        SonarCore.energyContainerHandlers = ASMLoader.getEnergyContainerHandlers(asmDataTable);
    }

    public static List<ISonarInventoryHandler> getInventoryHandlers(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances(asmDataTable, InventoryHandler.class, ISonarInventoryHandler.class, true, true);
    }

    public static List<ISonarEnergyHandler> getEnergyHandlers(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances(asmDataTable, EnergyHandler.class, ISonarEnergyHandler.class, true, true);
    }

    public static List<ISonarFluidHandler> getFluidHandlers(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances(asmDataTable, FluidHandler.class, ISonarFluidHandler.class, true, true);
    }

    public static List<ISonarEnergyContainerHandler> getEnergyContainerHandlers(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances(asmDataTable, EnergyContainerHandler.class, ISonarEnergyContainerHandler.class, true, true);
    }

    public static void log(ASMLog log, Class type, ASMDataTable.ASMData asm, String modid) {
        switch (log) {
            case ERROR: {
                SonarCore.logger.error("%s couldn't be loaded: {}", new Object[]{type.getSimpleName(), asm.getClassName()});
                break;
            }
            case LOADED: {
                SonarCore.logger.info("%s loaded successfully: {}", new Object[]{type.getSimpleName(), asm.getClassName()});
                break;
            }
            case MODID: {
                SonarCore.logger.error("Couldn't load %s %s for modid %s ", new Object[]{type.getSimpleName(), asm.getClassName(), modid});
                break;
            }
        }
    }

    public static <T> List<T> getInstances(@Nonnull ASMDataTable asmDataTable, Class annotation, Class<T> instanceClass, boolean checkModid, boolean sortPriority) {
        ArrayList<T> instances = new ArrayList<T>();
        String annotationClassName = annotation.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList data = Lists.newArrayList();
        asmDatas.forEach(asmData -> data.add(asmData));
        if (sortPriority) {
            data.sort(SORT_PRIORITY);
        }
        for (ASMDataTable.ASMData asmData2 : data) {
            String modid;
            String string = modid = checkModid ? (String)asmData2.getAnnotationInfo().get("modid") : "";
            if (!checkModid || Loader.isModLoaded((String)modid) || Loader.isModLoaded((String)modid.toLowerCase())) {
                try {
                    Class<?> asmClass = Class.forName(asmData2.getClassName());
                    Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                    T instance = asmInstanceClass.newInstance();
                    instances.add(instance);
                    ASMLoader.log(ASMLog.LOADED, instanceClass, asmData2, modid);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    ASMLoader.log(ASMLog.ERROR, instanceClass, asmData2, modid);
                }
                continue;
            }
            ASMLoader.log(ASMLog.MODID, instanceClass, asmData2, modid);
        }
        return instances;
    }

    public static <T> void injectInstances(ASMDataTable data, Class annotation, Class<T> instanceClass, Function<ASMDataTable.ASMData, T> create) {
        for (ASMDataTable.ASMData entry : data.getAll(annotation.getName())) {
            String targetClass = entry.getClassName();
            String targetName = entry.getObjectName();
            Object i = create.apply((Object)entry);
            if (i == null) {
                return;
            }
            try {
                Field field = Class.forName(targetClass).getDeclaredField(targetName);
                if ((field.getModifiers() & 8) != 8) {
                    SonarCore.logger.warn("Unable to inject instance %s at %s.%s (Non-Static)", new Object[]{i.toString(), targetClass, targetName});
                }
                EnumHelper.setFailsafeFieldValue((Field)field, null, (Object)i);
            }
            catch (Exception e) {
                e.printStackTrace();
                SonarCore.logger.warn("Unable to inject instance %s at %s.%s", new Object[]{i.toString(), targetClass, targetName});
            }
        }
    }

    public static <T> List<Pair<ASMDataTable.ASMData, Class<? extends T>>> getClasses(@Nonnull ASMDataTable asmDataTable, Class annotation, Class<T> instanceClass, boolean checkModid) {
        String annotationClassName = annotation.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<Pair<ASMDataTable.ASMData, Class<T>>> classes = new ArrayList<Pair<ASMDataTable.ASMData, Class<T>>>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            String modid;
            String string = modid = checkModid ? (String)asmData.getAnnotationInfo().get("modid") : "";
            if (!checkModid || Loader.isModLoaded((String)modid) || Loader.isModLoaded((String)modid.toLowerCase())) {
                try {
                    Class<?> asmClass = Class.forName(asmData.getClassName());
                    Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                    classes.add(new Pair<ASMDataTable.ASMData, Class<T>>(asmData, asmInstanceClass));
                    ASMLoader.log(ASMLog.LOADED, instanceClass, asmData, modid);
                }
                catch (ClassNotFoundException e) {
                    ASMLoader.log(ASMLog.ERROR, instanceClass, asmData, modid);
                }
                continue;
            }
            ASMLoader.log(ASMLog.MODID, instanceClass, asmData, modid);
        }
        return classes;
    }

    public static enum ASMLog {
        LOADED,
        ERROR,
        MODID;

    }
}

