/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.gui.widgets;

import org.lwjgl.input.Mouse;
import sonar.core.client.gui.GuiGridElement;
import sonar.core.client.gui.widgets.ScrollerOrientation;

public class SonarScroller {
    public boolean renderScroller = true;
    public float currentScroll;
    public boolean isScrolling;
    public boolean wasClicking;
    public int left;
    public int top;
    public int length;
    public int width;
    public ScrollerOrientation orientation = ScrollerOrientation.VERTICAL;

    public SonarScroller(int scrollerLeft, int scrollerStart, int length, int width) {
        this.left = scrollerLeft;
        this.top = scrollerStart;
        this.length = length;
        this.width = width;
    }

    public SonarScroller setOrientation(ScrollerOrientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public void handleMouse(GuiGridElement grid) {
        this.handleMouse(grid.isScrollable(), grid.getGridSize());
    }

    public void handleMouse(boolean needsScrollBars, int listSize) {
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && needsScrollBars) {
            int j = listSize + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void drawScreen(int x, int y, boolean needsScrollBars) {
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.left && y >= this.top && x < this.left + this.width && y < this.top + this.length) {
            this.isScrolling = needsScrollBars;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = this.orientation.isVertical() ? ((float)(y - this.top) - 7.5f) / ((float)this.length - 15.0f) : ((float)(x - this.left) - 7.5f) / ((float)this.width - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }
}

