/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network.wrappers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SyncableStack
extends SyncableObject {
    public ItemStack value;
    private ItemStack lastTickValue;

    public SyncableStack(ItemStack stack, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.value = this.lastTickValue = stack;
    }

    @Override
    public void detectAndSendChanges(TileBCBase tile, EntityPlayer player, boolean forceSync) {
        if (!ItemStack.func_77989_b((ItemStack)this.value, (ItemStack)this.lastTickValue)) {
            this.lastTickValue = this.value;
            if (tile != null) {
                BrandonsCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                BrandonsCore.network.sendTo((IMessage)new PacketSyncableObject(null, this.index, this.value, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                LogHelperBC.error("SyncableNBT#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 11) {
            this.value = this.lastTickValue = packet.stack;
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        if (this.value != null) {
            NBTTagCompound stackCompound = new NBTTagCompound();
            this.value.func_77955_b(stackCompound);
            compound.func_74782_a("SyncableStack" + this.index, (NBTBase)stackCompound);
        }
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableStack" + this.index)) {
            this.value = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("SyncableStack" + this.index));
        }
    }
}

