/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import java.io.IOException;

public class MGuiPopUpDialog
extends MGuiElementBase {
    public final MGuiElementBase parent;
    public boolean closeOnOutsideClick = true;
    public boolean closeOnCapturedClick = false;
    public boolean dragging = false;
    public int dragXOffset = 0;
    public int dragYOffset = 0;
    public boolean canDrag = false;
    public int dragZoneSize = 10;

    public MGuiPopUpDialog(IModularGui modularGui, MGuiElementBase parent) {
        super(modularGui);
        this.parent = parent;
        this.mc = parent.mc;
        this.fontRenderer = parent.fontRenderer;
    }

    public MGuiPopUpDialog(IModularGui modularGui, int xPos, int yPos, MGuiElementBase parent) {
        super(modularGui, xPos, yPos);
        this.parent = parent;
        this.mc = parent.mc;
        this.fontRenderer = parent.fontRenderer;
    }

    public MGuiPopUpDialog(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize, MGuiElementBase parent) {
        super(modularGui, xPos, yPos, xSize, ySize);
        this.parent = parent;
        this.mc = parent.mc;
        this.fontRenderer = parent.fontRenderer;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean flag;
        if (this.closeOnOutsideClick && !this.isMouseOver(mouseX, mouseY)) {
            this.close();
            return true;
        }
        if (this.canDrag && GuiHelper.isInRect(this.xPos, this.yPos, this.xSize, this.dragZoneSize, mouseX, mouseY)) {
            this.dragging = true;
            this.dragXOffset = mouseX - this.xPos;
            this.dragYOffset = mouseY - this.yPos;
        }
        if ((flag = super.mouseClicked(mouseX, mouseY, mouseButton)) && this.closeOnCapturedClick) {
            this.close();
        }
        return flag;
    }

    @Override
    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.dragging) {
            int xMove = mouseX - this.dragXOffset - this.xPos;
            int yMove = mouseY - this.dragYOffset - this.yPos;
            this.moveBy(xMove, yMove);
        }
        return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public MGuiPopUpDialog setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return this;
    }

    public MGuiPopUpDialog setCanDrag(boolean canDrag) {
        this.canDrag = canDrag;
        return this;
    }

    public MGuiPopUpDialog setCloseOnCapturedClick(boolean closeOnCapturedClick) {
        this.closeOnCapturedClick = closeOnCapturedClick;
        return this;
    }

    public void show() {
        this.modularGui.getManager().add(this, this.parent.displayLevel + 1);
    }

    public void close() {
        this.modularGui.getManager().remove(this);
    }
}

