/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import cofh.api.energy.IEnergyHandler;
import com.brandon3055.brandonscore.blocks.TileEnergyBase;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.Utils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;

public class MGuiEnergyBar
extends MGuiElementBase {
    private int energy = 0;
    private int maxEnergy = 0;
    private boolean drawHoveringText = true;
    private IEnergyHandler energyHandler;
    private boolean horizontal = false;

    public MGuiEnergyBar(IModularGui modularGui) {
        super(modularGui);
    }

    public MGuiEnergyBar(IModularGui modularGui, int xPos, int yPos) {
        super(modularGui, xPos, yPos);
    }

    public MGuiEnergyBar(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        super(modularGui, xPos, yPos, xSize, ySize);
    }

    public MGuiEnergyBar setEnergy(int energy, int maxEnergy) {
        this.energy = energy;
        this.maxEnergy = maxEnergy;
        return this;
    }

    public MGuiEnergyBar setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public MGuiEnergyBar setDrawHoveringText(boolean drawHoveringText) {
        this.drawHoveringText = drawHoveringText;
        return this;
    }

    public MGuiEnergyBar setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        return this;
    }

    public MGuiEnergyBar setEnergyHandler(IEnergyHandler energyHandler) {
        this.energyHandler = energyHandler;
        return this;
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        ResourceHelperBC.bindTexture("textures/gui/energy_gui.png");
        int size = this.horizontal ? this.xSize : this.ySize;
        int draw = (int)((double)this.energy / (double)this.maxEnergy * (double)(size - 2));
        int posY = this.yPos;
        int posX = this.xPos;
        if (this.horizontal) {
            int x = posY;
            posY = posX;
            posX = x;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(size + posY * 2), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(posX, posY, 0, 0, 14, size);
        this.drawTexturedModalRect(posX, posY + size - 1, 0, 255, 14, 1);
        this.drawTexturedModalRect(posX + 1, posY + size - draw - 1, 14, size - draw, 12, draw);
        if (this.horizontal) {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoveringText && this.isMouseOver(mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(InfoHelper.ITC() + I18n.func_135052_a((String)"gui.de.energyStorage.txt", (Object[])new Object[0]));
            list.add(InfoHelper.HITC() + Utils.formatNumber(this.energy) + " / " + Utils.formatNumber(this.maxEnergy));
            list.add(TextFormatting.GRAY + "[" + Utils.addCommas(this.energy) + " RF]");
            this.drawHoveringText(list, mouseX, mouseY, Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onUpdate() {
        if (this.energyHandler != null) {
            this.maxEnergy = this.energyHandler.getMaxEnergyStored(EnumFacing.UP);
            this.energy = this.energyHandler.getEnergyStored(EnumFacing.UP);
        }
        if (this.energyHandler instanceof TileEnergyBase) {
            this.energy = ((TileEnergyBase)((Object)this.energyHandler)).energyStored.value;
        }
        return super.onUpdate();
    }
}

