/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.config.FeatureWrapper;
import com.brandon3055.brandonscore.lib.ITilePlaceListener;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockBCore
extends ItemBlock {
    private FeatureWrapper feature;
    private String registryDomain = null;

    public ItemBlockBCore(Block block, FeatureWrapper feature) {
        super(block);
        this.feature = feature;
        this.func_77627_a(feature.variantMap().length > 0 || block instanceof BlockBCore && ((BlockBCore)block).nameOverrides.size() > 1);
    }

    public ItemBlockBCore(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public String func_77667_c(ItemStack stack) {
        if (this.field_150939_a instanceof BlockBCore && ((BlockBCore)this.field_150939_a).nameOverrides.containsKey(stack.func_77952_i())) {
            return "tile." + this.getRegistryDomain() + ":" + ((BlockBCore)this.field_150939_a).nameOverrides.get(stack.func_77952_i());
        }
        return super.func_77667_c(stack);
    }

    public int func_77647_b(int damage) {
        return this.func_77614_k() ? damage : 0;
    }

    public String getRegistryDomain() {
        if (this.registryDomain == null) {
            if (this.getRegistryName() == null) {
                return "null";
            }
            this.registryDomain = this.getRegistryName().func_110624_b();
        }
        return this.registryDomain;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        TileEntity tile = world.func_175625_s(pos);
        if (placed && tile instanceof ITilePlaceListener) {
            ((ITilePlaceListener)tile).onTilePlaced(world, pos, side, hitX, hitY, hitZ, player, stack);
        }
        return placed;
    }

    public boolean func_77651_p() {
        return super.func_77651_p();
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (this.field_150939_a instanceof BlockBCore && ((BlockBCore)this.field_150939_a).overrideShareTag()) {
            return ((BlockBCore)this.field_150939_a).getNBTShareTag(stack);
        }
        return super.getNBTShareTag(stack);
    }
}

