/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.api.IDataRetainerTile;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBCore
extends Block {
    public static final String TILE_DATA_TAG = "DETileData";
    protected boolean isFullCube = true;
    private boolean ifcSet = false;
    protected boolean canProvidePower = false;
    public Map<Integer, String> nameOverrides = new HashMap<Integer, String>();

    public BlockBCore() {
        this(Material.field_151576_e);
    }

    public BlockBCore(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        super.func_149666_a(item, tab, list);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IDataRetainerTile && ItemNBTHelper.getCompound(stack).func_74764_b(TILE_DATA_TAG)) {
            ((IDataRetainerTile)tile).readRetainedData(ItemNBTHelper.getCompound(stack).func_74775_l(TILE_DATA_TAG));
        }
    }

    public BlockBCore setHarvestTool(String toolClass, int level) {
        this.setHarvestLevel(toolClass, level);
        return this;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity;
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (stack.func_77973_b() == Item.func_150898_a((Block)this) && stack.func_77973_b().func_77614_k()) {
            stack.func_77964_b(this.func_176201_c(state));
        }
        if ((tileEntity = world.func_175625_s(pos)) instanceof IDataRetainerTile) {
            NBTTagCompound customData = new NBTTagCompound();
            ((IDataRetainerTile)tileEntity).onHarvested(stack);
            ((IDataRetainerTile)tileEntity).writeRetainedData(customData);
            ItemNBTHelper.getCompound(stack).func_74782_a(TILE_DATA_TAG, (NBTBase)customData);
        }
        return stack;
    }

    @Deprecated
    public BlockBCore setIsFullCube(boolean value) {
        this.ifcSet = true;
        this.isFullCube = value;
        return this;
    }

    public boolean uberIsBlockFullCube() {
        return !this.ifcSet || this.isFullCube;
    }

    public BlockBCore addName(int meta, String name) {
        this.nameOverrides.put(meta, name);
        return this;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.hasTileEntity(state)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof IRedstoneEmitter || this.canProvidePower;
        }
        return super.canConnectRedstone(state, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.hasTileEntity(state)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof IChangeListener;
        }
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (this.hasTileEntity(blockState) && (tile = blockAccess.func_175625_s(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getWeakPower(blockState, side);
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (this.hasTileEntity(blockState) && (tile = blockAccess.func_175625_s(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getStrongPower(blockState, side);
        }
        return super.func_176211_b(blockState, blockAccess, pos, side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        TileEntity tile;
        if (this.hasTileEntity(state) && (tile = world.func_175625_s(pos)) instanceof IChangeListener) {
            ((IChangeListener)tile).onNeighborChange();
        }
        super.func_189540_a(state, world, pos, blockIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (this.hasTileEntity(state) && (tile = worldIn.func_175625_s(pos)) instanceof IActivatableTile) {
            return ((IActivatableTile)tile).onBlockActivated(state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack heldStack) {
        if (te instanceof IDataRetainerTile) {
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77964_b(this.func_180651_a(state));
            ((IDataRetainerTile)te).onHarvested(stack);
            NBTTagCompound customData = new NBTTagCompound();
            ((IDataRetainerTile)te).writeRetainedData(customData);
            ItemNBTHelper.getCompound(stack).func_74782_a(TILE_DATA_TAG, (NBTBase)customData);
            BlockBCore.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            world.func_175713_t(pos);
        } else {
            super.func_180657_a(world, player, pos, state, te, heldStack);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return this.uberIsBlockFullCube();
    }

    public boolean func_149662_c(IBlockState state) {
        return this.uberIsBlockFullCube();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TILE_DATA_TAG)) {
            tooltip.add(I18n.func_135052_a((String)"info.de.hasSavedData.txt", (Object[])new Object[0]));
        }
    }

    public boolean overrideShareTag() {
        return false;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return stack.func_77978_p();
    }
}

