/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileEntityInventoryBase
extends TileEntityBase
implements ISidedInventory {
    private final SidedInvWrapper[] invWrappers = new SidedInvWrapper[6];
    public ItemStack[] slots;

    public TileEntityInventoryBase(int slots, String name) {
        super(name);
        this.slots = new ItemStack[slots];
        Arrays.fill(this.slots, StackUtil.getNull());
        if (this.hasInvWrapperCapabilities()) {
            this.getInvWrappers(this.invWrappers);
        }
    }

    public static void saveSlots(ItemStack[] slots, NBTTagCompound compound) {
        if (slots != null && slots.length > 0) {
            NBTTagList tagList = new NBTTagList();
            for (ItemStack slot : slots) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                if (StackUtil.isValid(slot)) {
                    slot.func_77955_b(tagCompound);
                }
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a("Items", (NBTBase)tagList);
        }
    }

    public static void loadSlots(ItemStack[] slots, NBTTagCompound compound) {
        if (slots != null && slots.length > 0) {
            NBTTagList tagList = compound.func_150295_c("Items", 10);
            for (int i = 0; i < slots.length; ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                slots[i] = tagCompound != null && tagCompound.func_74764_b("id") ? ItemStack.func_77949_a((NBTTagCompound)tagCompound) : StackUtil.getNull();
            }
        }
    }

    protected void getInvWrappers(SidedInvWrapper[] wrappers) {
        for (int i = 0; i < wrappers.length; ++i) {
            wrappers[i] = new SidedInvWrapper((ISidedInventory)this, EnumFacing.values()[i]);
        }
    }

    @Override
    public int getComparatorStrength() {
        return Container.func_94526_b((IInventory)this);
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            TileEntityInventoryBase.saveSlots(this.slots, compound);
        }
    }

    public boolean shouldSyncSlots() {
        return false;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            TileEntityInventoryBase.loadSlots(this.slots, compound);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        int invSize = this.func_70302_i_();
        if (invSize > 0) {
            int[] theInt = new int[invSize];
            for (int i = 0; i < theInt.length; ++i) {
                theInt[i] = i;
            }
            return theInt;
        }
        return new int[0];
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerUse(player);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.func_70304_b(i);
        }
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.slots[i] = stack;
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.func_70302_i_()) {
            return this.slots[i];
        }
        return StackUtil.getNull();
    }

    public ItemStack func_70298_a(int i, int j) {
        if (StackUtil.isValid(this.slots[i])) {
            if (StackUtil.getStackSize(this.slots[i]) <= j) {
                ItemStack stackAt = this.slots[i];
                this.slots[i] = StackUtil.getNull();
                this.func_70296_d();
                return stackAt;
            }
            ItemStack stackAt = this.slots[i].func_77979_a(j);
            if (StackUtil.getStackSize(this.slots[i]) <= 0) {
                this.slots[i] = StackUtil.getNull();
            }
            this.func_70296_d();
            return stackAt;
        }
        return StackUtil.getNull();
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.slots[index];
        this.slots[index] = StackUtil.getNull();
        return stack;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasInvWrapperCapabilities() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invWrappers[facing == null ? 0 : facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    public boolean hasInvWrapperCapabilities() {
        return true;
    }
}

