/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityFurnaceSolar
extends TileEntityBase
implements ISharingEnergyProvider,
IEnergyDisplay {
    public static final int PRODUCE = 8;
    public final EnergyStorage storage = new EnergyStorage(30000);
    private int oldEnergy;

    public TileEntityFurnaceSolar() {
        super("solarPanel");
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from != EnumFacing.UP;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            int power = this.getPowerToGenerate(8);
            if (this.field_145850_b.func_72935_r() && power > 0 && power <= this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) {
                this.storage.receiveEnergy(power, false);
                this.func_70296_d();
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    public int getPowerToGenerate(int power) {
        for (int y = 1; y <= this.field_145850_b.func_72800_K() - this.field_174879_c.func_177956_o() && power > 0; ++y) {
            BlockPos pos = this.field_174879_c.func_177981_b(y);
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (state.func_185904_a().func_76218_k()) {
                power = 0;
                continue;
            }
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, pos)) continue;
            --power;
        }
        return power;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public EnumFacing[] getEnergyShareSides() {
        return EnumFacing.values();
    }
}

