/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.ContainerCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FluidDisplay;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCoffeeMachine
extends GuiContainer {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("guiCoffeeMachine");
    private final TileEntityCoffeeMachine machine;
    private EnergyDisplay energy;
    private FluidDisplay fluid;

    public GuiCoffeeMachine(InventoryPlayer inventory, TileEntityBase tile) {
        super((Container)new ContainerCoffeeMachine(inventory, tile));
        this.machine = (TileEntityCoffeeMachine)tile;
        this.field_146999_f = 176;
        this.field_147000_g = 179;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.energy.onMouseClick(mouseX, mouseY, mouseButton);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiButton buttonOkay = new GuiButton(0, this.field_147003_i + 60, this.field_147009_r + 11, 58, 20, StringUtil.localize("info.actuallyadditions.gui.ok"));
        this.field_146292_n.add(buttonOkay);
        this.energy = new EnergyDisplay(this.field_147003_i + 16, this.field_147009_r + 5, this.machine.storage);
        this.fluid = new FluidDisplay(this.field_147003_i - 30, this.field_147009_r + 1, this.machine.tank, true, false);
    }

    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        String text1 = this.machine.storage.getEnergyStored() + "/" + this.machine.storage.getMaxEnergyStored() + " RF";
        if (x >= this.field_147003_i + 16 && y >= this.field_147009_r + 5 && x <= this.field_147003_i + 23 && y <= this.field_147009_r + 89) {
            this.func_146283_a(Collections.singletonList(text1), x, y);
        }
        String text2 = this.machine.coffeeCacheAmount + "/" + 300 + " " + StringUtil.localize("info.actuallyadditions.gui.coffee");
        if (x >= this.field_147003_i + 40 && y >= this.field_147009_r + 25 && x <= this.field_147003_i + 49 && y <= this.field_147009_r + 56) {
            this.func_146283_a(Collections.singletonList(text2), x, y);
        }
        this.energy.drawOverlay(x, y);
        this.fluid.drawOverlay(x, y);
    }

    public void func_146979_b(int x, int y) {
        AssetUtil.displayNameString(this.field_146289_q, this.field_146999_f, -10, this.machine);
    }

    public void func_146976_a(float f, int x, int y) {
        int i;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetUtil.GUI_INVENTORY_LOCATION);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + 93, 0, 0, 176, 86);
        this.field_146297_k.func_110434_K().func_110577_a(RES_LOC);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 93);
        if (this.machine.coffeeCacheAmount > 0) {
            i = this.machine.getCoffeeScaled(30);
            this.func_73729_b(this.field_147003_i + 41, this.field_147009_r + 56 - i, 192, 0, 8, i);
        }
        if (this.machine.brewTime > 0) {
            i = this.machine.getBrewScaled(23);
            this.func_73729_b(this.field_147003_i + 53, this.field_147009_r + 42, 192, 30, i, 16);
            int j = this.machine.getBrewScaled(26);
            this.func_73729_b(this.field_147003_i + 99 + 25 - j, this.field_147009_r + 44, 217 - j, 46, j, 12);
        }
        this.energy.draw();
        this.fluid.draw();
    }

    public void func_146284_a(GuiButton button) {
        PacketHandlerHelper.sendButtonPacket(this.machine, button.field_146127_k);
    }
}

