/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.gui;

import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.api.booklet.internal.GuiBookletBase;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.misc.BookletUtils;
import de.ellpeck.actuallyadditions.mod.booklet.page.ItemDisplay;
import de.ellpeck.actuallyadditions.mod.inventory.gui.TexturedButton;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPage
extends GuiBooklet {
    public final IBookletPage[] pages = new IBookletPage[2];
    private final List<ItemDisplay> itemDisplays = new ArrayList<ItemDisplay>();
    private int pageTimer;
    private GuiButton buttonViewOnline;

    public GuiPage(GuiScreen previousScreen, GuiBookletBase parentPage, IBookletPage page1, IBookletPage page2) {
        super(previousScreen, parentPage);
        this.pages[0] = page1;
        this.pages[1] = page2;
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (ItemDisplay display : this.itemDisplays) {
            display.onMousePress(mouseButton, mouseX, mouseY);
        }
        for (IBookletPage page : this.pages) {
            if (page == null) continue;
            page.mouseClicked(this, mouseX, mouseY, mouseButton);
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        for (IBookletPage page : this.pages) {
            if (page == null) continue;
            page.mouseReleased(this, mouseX, mouseY, state);
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (IBookletPage page : this.pages) {
            if (page == null) continue;
            page.mouseClickMove(this, mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        block5: {
            block4: {
                if (button != this.buttonViewOnline) break block4;
                List<String> links = this.getWebLinks();
                if (!Desktop.isDesktopSupported()) break block5;
                for (String link : links) {
                    try {
                        Desktop.getDesktop().browse(new URI(link));
                    }
                    catch (Exception e) {
                        ModUtil.LOGGER.error("Couldn't open website from Booklet page!", (Throwable)e);
                    }
                }
                break block5;
            }
            super.func_146284_a(button);
            for (IBookletPage page : this.pages) {
                if (page == null) continue;
                page.actionPerformed(this, button);
            }
        }
    }

    @Override
    public void func_73866_w_() {
        this.itemDisplays.clear();
        super.func_73866_w_();
        List<String> links = this.getWebLinks();
        if (links != null && !links.isEmpty()) {
            this.buttonViewOnline = new TexturedButton(RES_LOC_GADGETS, -782822, this.guiLeft + this.xSize - 24, this.guiTop + this.ySize - 25, 0, 172, 16, 16, Collections.singletonList(TextFormatting.GOLD + "View Online"));
            this.field_146292_n.add(this.buttonViewOnline);
        }
        for (int i = 0; i < this.pages.length; ++i) {
            IBookletPage page = this.pages[i];
            if (page == null) continue;
            page.initGui(this, this.guiLeft + 6 + i * 142, this.guiTop + 7);
        }
    }

    private List<String> getWebLinks() {
        ArrayList<String> links = new ArrayList<String>();
        for (IBookletPage page : this.pages) {
            String link;
            if (page == null || (link = page.getWebLink()) == null || links.contains(link)) continue;
            links.add(link);
        }
        return links;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        for (int i = 0; i < this.pages.length; ++i) {
            IBookletPage page = this.pages[i];
            if (page == null) continue;
            page.updateScreen(this, this.guiLeft + 6 + i * 142, this.guiTop + 7, this.pageTimer);
        }
        ++this.pageTimer;
    }

    @Override
    public void drawScreenPre(int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(mouseX, mouseY, partialTicks);
        if (this.pages[0] != null) {
            IBookletChapter chapter = this.pages[0].getChapter();
            String name = chapter.getLocalizedName();
            this.field_146289_q.func_175065_a(name, (float)(this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(name) / 2), (float)(this.guiTop - 1), 0xFFFFFF, true);
        }
        for (int i = 0; i < this.pages.length; ++i) {
            IBookletPage page = this.pages[i];
            if (page == null) continue;
            IBookletChapter chapter = this.pages[i].getChapter();
            String pageStrg = "Page " + (chapter.getPageIndex(this.pages[i]) + 1) + "/" + chapter.getAllPages().length;
            this.renderScaledAsciiString(pageStrg, this.guiLeft + 25 + i * 136, this.guiTop + this.ySize - 7, 0xFFFFFF, false, 0.8f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            page.drawScreenPre(this, this.guiLeft + 6 + i * 142, this.guiTop + 7, mouseX, mouseY, partialTicks);
        }
        for (ItemDisplay display : this.itemDisplays) {
            display.drawPre();
        }
    }

    @Override
    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPost(mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.pages.length; ++i) {
            IBookletPage page = this.pages[i];
            if (page == null) continue;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            page.drawScreenPost(this, this.guiLeft + 6 + i * 142, this.guiTop + 7, mouseX, mouseY, partialTicks);
        }
        for (ItemDisplay display : this.itemDisplays) {
            display.drawPost(mouseX, mouseY);
        }
    }

    @Override
    public void addOrModifyItemRenderer(ItemStack renderedStack, int x, int y, float scale, boolean shouldTryTransfer) {
        for (ItemDisplay display : this.itemDisplays) {
            if (display.x != x || display.y != y || display.scale != scale) continue;
            display.stack = renderedStack;
            return;
        }
        this.itemDisplays.add(new ItemDisplay(this, x, y, scale, renderedStack, shouldTryTransfer));
    }

    @Override
    public boolean hasPageLeftButton() {
        IBookletChapter chapter;
        IBookletPage page = this.pages[0];
        if (page != null && (chapter = page.getChapter()) != null) {
            return chapter.getPageIndex(page) > 0;
        }
        return false;
    }

    @Override
    public void onPageLeftButtonPressed() {
        IBookletChapter chapter;
        IBookletPage page = this.pages[0];
        if (page != null && (chapter = page.getChapter()) != null) {
            IBookletPage[] pages = chapter.getAllPages();
            int pageNumToOpen = chapter.getPageIndex(page) - 1;
            if (pageNumToOpen >= 0 && pageNumToOpen < pages.length) {
                this.field_146297_k.func_147108_a((GuiScreen)BookletUtils.createPageGui(this.previousScreen, this.parentPage, pages[pageNumToOpen]));
            }
        }
    }

    @Override
    public boolean hasPageRightButton() {
        IBookletChapter chapter;
        IBookletPage page = this.pages[1];
        if (page != null && (chapter = page.getChapter()) != null) {
            int pageAmount;
            int pageIndex = chapter.getPageIndex(page);
            return pageIndex + 1 < (pageAmount = chapter.getAllPages().length);
        }
        return false;
    }

    @Override
    public void onPageRightButtonPressed() {
        IBookletChapter chapter;
        IBookletPage page = this.pages[1];
        if (page != null && (chapter = page.getChapter()) != null) {
            IBookletPage[] pages = chapter.getAllPages();
            int pageNumToOpen = chapter.getPageIndex(page) + 1;
            if (pageNumToOpen >= 0 && pageNumToOpen < pages.length) {
                this.field_146297_k.func_147108_a((GuiScreen)BookletUtils.createPageGui(this.previousScreen, this.parentPage, pages[pageNumToOpen]));
            }
        }
    }

    @Override
    public boolean hasBackButton() {
        return true;
    }

    @Override
    public void onBackButtonPressed() {
        if (!GuiPage.func_146272_n()) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentPage);
        } else {
            super.onBackButtonPressed();
        }
    }
}

