/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCoffeeMachine
extends BlockContainerBase {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)3);

    public BlockCoffeeMachine(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing f6, float f7, float f8, float f9) {
        if (!world.field_72995_K) {
            TileEntityCoffeeMachine machine = (TileEntityCoffeeMachine)world.func_175625_s(pos);
            if (machine != null && this.checkFailUseItemOnTank(player, stack, machine.tank)) {
                player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.COFFEE_MACHINE.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCoffeeMachine();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropInventory(world, pos);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (rotation == 0) {
            world.func_180501_a(pos, this.func_176203_a(0), 2);
        }
        if (rotation == 1) {
            world.func_180501_a(pos, this.func_176203_a(3), 2);
        }
        if (rotation == 2) {
            world.func_180501_a(pos, this.func_176203_a(1), 2);
        }
        if (rotation == 3) {
            world.func_180501_a(pos, this.func_176203_a(2), 2);
        }
        super.func_180633_a(world, pos, state, player, stack);
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }
}

